<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtendedProperty StructType
 * @subpackage Structs
 */
class ExtendedProperty extends AbstractStructBase
{
    /**
     * The PropertyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PropertyName;
    /**
     * The PropertyValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $PropertyValue;
    /**
     * Constructor method for ExtendedProperty
     * @uses ExtendedProperty::setPropertyName()
     * @uses ExtendedProperty::setPropertyValue()
     * @param string $propertyName
     * @param mixed $propertyValue
     */
    public function __construct($propertyName = null, $propertyValue = null)
    {
        $this
            ->setPropertyName($propertyName)
            ->setPropertyValue($propertyValue);
    }
    /**
     * Get PropertyName value
     * @return string|null
     */
    public function getPropertyName()
    {
        return $this->PropertyName;
    }
    /**
     * Set PropertyName value
     * @param string $propertyName
     * @return \StructType\ExtendedProperty
     */
    public function setPropertyName($propertyName = null)
    {
        // validation for constraint: string
        if (!is_null($propertyName) && !is_string($propertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyName)), __LINE__);
        }
        $this->PropertyName = $propertyName;
        return $this;
    }
    /**
     * Get PropertyValue value
     * @return mixed|null
     */
    public function getPropertyValue()
    {
        return $this->PropertyValue;
    }
    /**
     * Set PropertyValue value
     * @param mixed $propertyValue
     * @return \StructType\ExtendedProperty
     */
    public function setPropertyValue($propertyValue = null)
    {
        $this->PropertyValue = $propertyValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtendedProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
