<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateAccount StructType
 * @subpackage Structs
 */
class CreateAccount extends AbstractStructBase
{
    /**
     * The AllowWebServiceAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowWebServiceAccess;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The AccountName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountName;
    /**
     * The LoginUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginUserID;
    /**
     * The LoginUserIDPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginUserIDPassword;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Surname;
    /**
     * The JobTitle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobTitle;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telephone;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The ReferredBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferredBy;
    /**
     * The HowDidYouFindUs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HowDidYouFindUs;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for CreateAccount
     * @uses CreateAccount::setAllowWebServiceAccess()
     * @uses CreateAccount::setUsername()
     * @uses CreateAccount::setPassword()
     * @uses CreateAccount::setAccountName()
     * @uses CreateAccount::setLoginUserID()
     * @uses CreateAccount::setLoginUserIDPassword()
     * @uses CreateAccount::setTitle()
     * @uses CreateAccount::setFirstName()
     * @uses CreateAccount::setSurname()
     * @uses CreateAccount::setJobTitle()
     * @uses CreateAccount::setTelephone()
     * @uses CreateAccount::setAddress()
     * @uses CreateAccount::setEmailAddress()
     * @uses CreateAccount::setReferredBy()
     * @uses CreateAccount::setHowDidYouFindUs()
     * @uses CreateAccount::setReturnFormat()
     * @param bool $allowWebServiceAccess
     * @param string $username
     * @param string $password
     * @param string $accountName
     * @param string $loginUserID
     * @param string $loginUserIDPassword
     * @param string $title
     * @param string $firstName
     * @param string $surname
     * @param string $jobTitle
     * @param string $telephone
     * @param string $address
     * @param string $emailAddress
     * @param string $referredBy
     * @param string $howDidYouFindUs
     * @param string $returnFormat
     */
    public function __construct($allowWebServiceAccess = null, $username = null, $password = null, $accountName = null, $loginUserID = null, $loginUserIDPassword = null, $title = null, $firstName = null, $surname = null, $jobTitle = null, $telephone = null, $address = null, $emailAddress = null, $referredBy = null, $howDidYouFindUs = null, $returnFormat = null)
    {
        $this
            ->setAllowWebServiceAccess($allowWebServiceAccess)
            ->setUsername($username)
            ->setPassword($password)
            ->setAccountName($accountName)
            ->setLoginUserID($loginUserID)
            ->setLoginUserIDPassword($loginUserIDPassword)
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setSurname($surname)
            ->setJobTitle($jobTitle)
            ->setTelephone($telephone)
            ->setAddress($address)
            ->setEmailAddress($emailAddress)
            ->setReferredBy($referredBy)
            ->setHowDidYouFindUs($howDidYouFindUs)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get AllowWebServiceAccess value
     * @return bool
     */
    public function getAllowWebServiceAccess()
    {
        return $this->AllowWebServiceAccess;
    }
    /**
     * Set AllowWebServiceAccess value
     * @param bool $allowWebServiceAccess
     * @return \StructType\CreateAccount
     */
    public function setAllowWebServiceAccess($allowWebServiceAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowWebServiceAccess) && !is_bool($allowWebServiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowWebServiceAccess)), __LINE__);
        }
        $this->AllowWebServiceAccess = $allowWebServiceAccess;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\CreateAccount
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\CreateAccount
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get AccountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->AccountName;
    }
    /**
     * Set AccountName value
     * @param string $accountName
     * @return \StructType\CreateAccount
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountName)), __LINE__);
        }
        $this->AccountName = $accountName;
        return $this;
    }
    /**
     * Get LoginUserID value
     * @return string|null
     */
    public function getLoginUserID()
    {
        return $this->LoginUserID;
    }
    /**
     * Set LoginUserID value
     * @param string $loginUserID
     * @return \StructType\CreateAccount
     */
    public function setLoginUserID($loginUserID = null)
    {
        // validation for constraint: string
        if (!is_null($loginUserID) && !is_string($loginUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginUserID)), __LINE__);
        }
        $this->LoginUserID = $loginUserID;
        return $this;
    }
    /**
     * Get LoginUserIDPassword value
     * @return string|null
     */
    public function getLoginUserIDPassword()
    {
        return $this->LoginUserIDPassword;
    }
    /**
     * Set LoginUserIDPassword value
     * @param string $loginUserIDPassword
     * @return \StructType\CreateAccount
     */
    public function setLoginUserIDPassword($loginUserIDPassword = null)
    {
        // validation for constraint: string
        if (!is_null($loginUserIDPassword) && !is_string($loginUserIDPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginUserIDPassword)), __LINE__);
        }
        $this->LoginUserIDPassword = $loginUserIDPassword;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\CreateAccount
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\CreateAccount
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\CreateAccount
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get JobTitle value
     * @return string|null
     */
    public function getJobTitle()
    {
        return $this->JobTitle;
    }
    /**
     * Set JobTitle value
     * @param string $jobTitle
     * @return \StructType\CreateAccount
     */
    public function setJobTitle($jobTitle = null)
    {
        // validation for constraint: string
        if (!is_null($jobTitle) && !is_string($jobTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jobTitle)), __LINE__);
        }
        $this->JobTitle = $jobTitle;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \StructType\CreateAccount
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\CreateAccount
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\CreateAccount
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get ReferredBy value
     * @return string|null
     */
    public function getReferredBy()
    {
        return $this->ReferredBy;
    }
    /**
     * Set ReferredBy value
     * @param string $referredBy
     * @return \StructType\CreateAccount
     */
    public function setReferredBy($referredBy = null)
    {
        // validation for constraint: string
        if (!is_null($referredBy) && !is_string($referredBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referredBy)), __LINE__);
        }
        $this->ReferredBy = $referredBy;
        return $this;
    }
    /**
     * Get HowDidYouFindUs value
     * @return string|null
     */
    public function getHowDidYouFindUs()
    {
        return $this->HowDidYouFindUs;
    }
    /**
     * Set HowDidYouFindUs value
     * @param string $howDidYouFindUs
     * @return \StructType\CreateAccount
     */
    public function setHowDidYouFindUs($howDidYouFindUs = null)
    {
        // validation for constraint: string
        if (!is_null($howDidYouFindUs) && !is_string($howDidYouFindUs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($howDidYouFindUs)), __LINE__);
        }
        $this->HowDidYouFindUs = $howDidYouFindUs;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\CreateAccount
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
