<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddUser StructType
 * @subpackage Structs
 */
class AddUser extends AbstractStructBase
{
    /**
     * The AllowWebServiceAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AllowWebServiceAccess;
    /**
     * The AccountDataAdministrator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AccountDataAdministrator;
    /**
     * The ApprovingAdministrator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ApprovingAdministrator;
    /**
     * The CanSpendCredit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CanSpendCredit;
    /**
     * The DefaultMailingsToAdvanceMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DefaultMailingsToAdvanceMode;
    /**
     * The DoNotSendEmails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DoNotSendEmails;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The LoginUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginUserID;
    /**
     * The LoginUserIDPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginUserIDPassword;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Surname;
    /**
     * The JobTitle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobTitle;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telephone;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The AccountRole
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountRole;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for AddUser
     * @uses AddUser::setAllowWebServiceAccess()
     * @uses AddUser::setAccountDataAdministrator()
     * @uses AddUser::setApprovingAdministrator()
     * @uses AddUser::setCanSpendCredit()
     * @uses AddUser::setDefaultMailingsToAdvanceMode()
     * @uses AddUser::setDoNotSendEmails()
     * @uses AddUser::setUsername()
     * @uses AddUser::setPassword()
     * @uses AddUser::setLoginUserID()
     * @uses AddUser::setLoginUserIDPassword()
     * @uses AddUser::setTitle()
     * @uses AddUser::setFirstName()
     * @uses AddUser::setSurname()
     * @uses AddUser::setJobTitle()
     * @uses AddUser::setTelephone()
     * @uses AddUser::setAddress()
     * @uses AddUser::setEmailAddress()
     * @uses AddUser::setAccountRole()
     * @uses AddUser::setReturnFormat()
     * @param bool $allowWebServiceAccess
     * @param bool $accountDataAdministrator
     * @param bool $approvingAdministrator
     * @param bool $canSpendCredit
     * @param bool $defaultMailingsToAdvanceMode
     * @param bool $doNotSendEmails
     * @param string $username
     * @param string $password
     * @param string $loginUserID
     * @param string $loginUserIDPassword
     * @param string $title
     * @param string $firstName
     * @param string $surname
     * @param string $jobTitle
     * @param string $telephone
     * @param string $address
     * @param string $emailAddress
     * @param string $accountRole
     * @param string $returnFormat
     */
    public function __construct($allowWebServiceAccess = null, $accountDataAdministrator = null, $approvingAdministrator = null, $canSpendCredit = null, $defaultMailingsToAdvanceMode = null, $doNotSendEmails = null, $username = null, $password = null, $loginUserID = null, $loginUserIDPassword = null, $title = null, $firstName = null, $surname = null, $jobTitle = null, $telephone = null, $address = null, $emailAddress = null, $accountRole = null, $returnFormat = null)
    {
        $this
            ->setAllowWebServiceAccess($allowWebServiceAccess)
            ->setAccountDataAdministrator($accountDataAdministrator)
            ->setApprovingAdministrator($approvingAdministrator)
            ->setCanSpendCredit($canSpendCredit)
            ->setDefaultMailingsToAdvanceMode($defaultMailingsToAdvanceMode)
            ->setDoNotSendEmails($doNotSendEmails)
            ->setUsername($username)
            ->setPassword($password)
            ->setLoginUserID($loginUserID)
            ->setLoginUserIDPassword($loginUserIDPassword)
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setSurname($surname)
            ->setJobTitle($jobTitle)
            ->setTelephone($telephone)
            ->setAddress($address)
            ->setEmailAddress($emailAddress)
            ->setAccountRole($accountRole)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get AllowWebServiceAccess value
     * @return bool
     */
    public function getAllowWebServiceAccess()
    {
        return $this->AllowWebServiceAccess;
    }
    /**
     * Set AllowWebServiceAccess value
     * @param bool $allowWebServiceAccess
     * @return \StructType\AddUser
     */
    public function setAllowWebServiceAccess($allowWebServiceAccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowWebServiceAccess) && !is_bool($allowWebServiceAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowWebServiceAccess)), __LINE__);
        }
        $this->AllowWebServiceAccess = $allowWebServiceAccess;
        return $this;
    }
    /**
     * Get AccountDataAdministrator value
     * @return bool
     */
    public function getAccountDataAdministrator()
    {
        return $this->AccountDataAdministrator;
    }
    /**
     * Set AccountDataAdministrator value
     * @param bool $accountDataAdministrator
     * @return \StructType\AddUser
     */
    public function setAccountDataAdministrator($accountDataAdministrator = null)
    {
        // validation for constraint: boolean
        if (!is_null($accountDataAdministrator) && !is_bool($accountDataAdministrator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($accountDataAdministrator)), __LINE__);
        }
        $this->AccountDataAdministrator = $accountDataAdministrator;
        return $this;
    }
    /**
     * Get ApprovingAdministrator value
     * @return bool
     */
    public function getApprovingAdministrator()
    {
        return $this->ApprovingAdministrator;
    }
    /**
     * Set ApprovingAdministrator value
     * @param bool $approvingAdministrator
     * @return \StructType\AddUser
     */
    public function setApprovingAdministrator($approvingAdministrator = null)
    {
        // validation for constraint: boolean
        if (!is_null($approvingAdministrator) && !is_bool($approvingAdministrator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($approvingAdministrator)), __LINE__);
        }
        $this->ApprovingAdministrator = $approvingAdministrator;
        return $this;
    }
    /**
     * Get CanSpendCredit value
     * @return bool
     */
    public function getCanSpendCredit()
    {
        return $this->CanSpendCredit;
    }
    /**
     * Set CanSpendCredit value
     * @param bool $canSpendCredit
     * @return \StructType\AddUser
     */
    public function setCanSpendCredit($canSpendCredit = null)
    {
        // validation for constraint: boolean
        if (!is_null($canSpendCredit) && !is_bool($canSpendCredit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($canSpendCredit)), __LINE__);
        }
        $this->CanSpendCredit = $canSpendCredit;
        return $this;
    }
    /**
     * Get DefaultMailingsToAdvanceMode value
     * @return bool
     */
    public function getDefaultMailingsToAdvanceMode()
    {
        return $this->DefaultMailingsToAdvanceMode;
    }
    /**
     * Set DefaultMailingsToAdvanceMode value
     * @param bool $defaultMailingsToAdvanceMode
     * @return \StructType\AddUser
     */
    public function setDefaultMailingsToAdvanceMode($defaultMailingsToAdvanceMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultMailingsToAdvanceMode) && !is_bool($defaultMailingsToAdvanceMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($defaultMailingsToAdvanceMode)), __LINE__);
        }
        $this->DefaultMailingsToAdvanceMode = $defaultMailingsToAdvanceMode;
        return $this;
    }
    /**
     * Get DoNotSendEmails value
     * @return bool
     */
    public function getDoNotSendEmails()
    {
        return $this->DoNotSendEmails;
    }
    /**
     * Set DoNotSendEmails value
     * @param bool $doNotSendEmails
     * @return \StructType\AddUser
     */
    public function setDoNotSendEmails($doNotSendEmails = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotSendEmails) && !is_bool($doNotSendEmails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($doNotSendEmails)), __LINE__);
        }
        $this->DoNotSendEmails = $doNotSendEmails;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\AddUser
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AddUser
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get LoginUserID value
     * @return string|null
     */
    public function getLoginUserID()
    {
        return $this->LoginUserID;
    }
    /**
     * Set LoginUserID value
     * @param string $loginUserID
     * @return \StructType\AddUser
     */
    public function setLoginUserID($loginUserID = null)
    {
        // validation for constraint: string
        if (!is_null($loginUserID) && !is_string($loginUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginUserID)), __LINE__);
        }
        $this->LoginUserID = $loginUserID;
        return $this;
    }
    /**
     * Get LoginUserIDPassword value
     * @return string|null
     */
    public function getLoginUserIDPassword()
    {
        return $this->LoginUserIDPassword;
    }
    /**
     * Set LoginUserIDPassword value
     * @param string $loginUserIDPassword
     * @return \StructType\AddUser
     */
    public function setLoginUserIDPassword($loginUserIDPassword = null)
    {
        // validation for constraint: string
        if (!is_null($loginUserIDPassword) && !is_string($loginUserIDPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginUserIDPassword)), __LINE__);
        }
        $this->LoginUserIDPassword = $loginUserIDPassword;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\AddUser
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\AddUser
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\AddUser
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get JobTitle value
     * @return string|null
     */
    public function getJobTitle()
    {
        return $this->JobTitle;
    }
    /**
     * Set JobTitle value
     * @param string $jobTitle
     * @return \StructType\AddUser
     */
    public function setJobTitle($jobTitle = null)
    {
        // validation for constraint: string
        if (!is_null($jobTitle) && !is_string($jobTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jobTitle)), __LINE__);
        }
        $this->JobTitle = $jobTitle;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \StructType\AddUser
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\AddUser
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\AddUser
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get AccountRole value
     * @return string|null
     */
    public function getAccountRole()
    {
        return $this->AccountRole;
    }
    /**
     * Set AccountRole value
     * @param string $accountRole
     * @return \StructType\AddUser
     */
    public function setAccountRole($accountRole = null)
    {
        // validation for constraint: string
        if (!is_null($accountRole) && !is_string($accountRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountRole)), __LINE__);
        }
        $this->AccountRole = $accountRole;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\AddUser
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
