<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddDesignerText StructType
 * @subpackage Structs
 */
class AddDesignerText extends AbstractStructBase
{
    /**
     * The MailingGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $MailingGUID;
    /**
     * The FontSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FontSize;
    /**
     * The Bold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Bold;
    /**
     * The Italic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Italic;
    /**
     * The Underline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Underline;
    /**
     * The FontColourRed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FontColourRed;
    /**
     * The FontColourGreen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FontColourGreen;
    /**
     * The FontColourBlue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FontColourBlue;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The PartDisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartDisplayName;
    /**
     * The TextContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TextContent;
    /**
     * The FontName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FontName;
    /**
     * The TextJustification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TextJustification;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for AddDesignerText
     * @uses AddDesignerText::setMailingGUID()
     * @uses AddDesignerText::setFontSize()
     * @uses AddDesignerText::setBold()
     * @uses AddDesignerText::setItalic()
     * @uses AddDesignerText::setUnderline()
     * @uses AddDesignerText::setFontColourRed()
     * @uses AddDesignerText::setFontColourGreen()
     * @uses AddDesignerText::setFontColourBlue()
     * @uses AddDesignerText::setUsername()
     * @uses AddDesignerText::setPassword()
     * @uses AddDesignerText::setPartDisplayName()
     * @uses AddDesignerText::setTextContent()
     * @uses AddDesignerText::setFontName()
     * @uses AddDesignerText::setTextJustification()
     * @uses AddDesignerText::setReturnFormat()
     * @param string $mailingGUID
     * @param int $fontSize
     * @param bool $bold
     * @param bool $italic
     * @param bool $underline
     * @param int $fontColourRed
     * @param int $fontColourGreen
     * @param int $fontColourBlue
     * @param string $username
     * @param string $password
     * @param string $partDisplayName
     * @param string $textContent
     * @param string $fontName
     * @param string $textJustification
     * @param string $returnFormat
     */
    public function __construct($mailingGUID = null, $fontSize = null, $bold = null, $italic = null, $underline = null, $fontColourRed = null, $fontColourGreen = null, $fontColourBlue = null, $username = null, $password = null, $partDisplayName = null, $textContent = null, $fontName = null, $textJustification = null, $returnFormat = null)
    {
        $this
            ->setMailingGUID($mailingGUID)
            ->setFontSize($fontSize)
            ->setBold($bold)
            ->setItalic($italic)
            ->setUnderline($underline)
            ->setFontColourRed($fontColourRed)
            ->setFontColourGreen($fontColourGreen)
            ->setFontColourBlue($fontColourBlue)
            ->setUsername($username)
            ->setPassword($password)
            ->setPartDisplayName($partDisplayName)
            ->setTextContent($textContent)
            ->setFontName($fontName)
            ->setTextJustification($textJustification)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get MailingGUID value
     * @return string
     */
    public function getMailingGUID()
    {
        return $this->MailingGUID;
    }
    /**
     * Set MailingGUID value
     * @param string $mailingGUID
     * @return \StructType\AddDesignerText
     */
    public function setMailingGUID($mailingGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mailingGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($mailingGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mailingGUID) && !is_string($mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingGUID)), __LINE__);
        }
        $this->MailingGUID = $mailingGUID;
        return $this;
    }
    /**
     * Get FontSize value
     * @return int
     */
    public function getFontSize()
    {
        return $this->FontSize;
    }
    /**
     * Set FontSize value
     * @param int $fontSize
     * @return \StructType\AddDesignerText
     */
    public function setFontSize($fontSize = null)
    {
        // validation for constraint: int
        if (!is_null($fontSize) && !is_numeric($fontSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fontSize)), __LINE__);
        }
        $this->FontSize = $fontSize;
        return $this;
    }
    /**
     * Get Bold value
     * @return bool
     */
    public function getBold()
    {
        return $this->Bold;
    }
    /**
     * Set Bold value
     * @param bool $bold
     * @return \StructType\AddDesignerText
     */
    public function setBold($bold = null)
    {
        // validation for constraint: boolean
        if (!is_null($bold) && !is_bool($bold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($bold)), __LINE__);
        }
        $this->Bold = $bold;
        return $this;
    }
    /**
     * Get Italic value
     * @return bool
     */
    public function getItalic()
    {
        return $this->Italic;
    }
    /**
     * Set Italic value
     * @param bool $italic
     * @return \StructType\AddDesignerText
     */
    public function setItalic($italic = null)
    {
        // validation for constraint: boolean
        if (!is_null($italic) && !is_bool($italic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($italic)), __LINE__);
        }
        $this->Italic = $italic;
        return $this;
    }
    /**
     * Get Underline value
     * @return bool
     */
    public function getUnderline()
    {
        return $this->Underline;
    }
    /**
     * Set Underline value
     * @param bool $underline
     * @return \StructType\AddDesignerText
     */
    public function setUnderline($underline = null)
    {
        // validation for constraint: boolean
        if (!is_null($underline) && !is_bool($underline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($underline)), __LINE__);
        }
        $this->Underline = $underline;
        return $this;
    }
    /**
     * Get FontColourRed value
     * @return int
     */
    public function getFontColourRed()
    {
        return $this->FontColourRed;
    }
    /**
     * Set FontColourRed value
     * @param int $fontColourRed
     * @return \StructType\AddDesignerText
     */
    public function setFontColourRed($fontColourRed = null)
    {
        // validation for constraint: int
        if (!is_null($fontColourRed) && !is_numeric($fontColourRed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fontColourRed)), __LINE__);
        }
        $this->FontColourRed = $fontColourRed;
        return $this;
    }
    /**
     * Get FontColourGreen value
     * @return int
     */
    public function getFontColourGreen()
    {
        return $this->FontColourGreen;
    }
    /**
     * Set FontColourGreen value
     * @param int $fontColourGreen
     * @return \StructType\AddDesignerText
     */
    public function setFontColourGreen($fontColourGreen = null)
    {
        // validation for constraint: int
        if (!is_null($fontColourGreen) && !is_numeric($fontColourGreen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fontColourGreen)), __LINE__);
        }
        $this->FontColourGreen = $fontColourGreen;
        return $this;
    }
    /**
     * Get FontColourBlue value
     * @return int
     */
    public function getFontColourBlue()
    {
        return $this->FontColourBlue;
    }
    /**
     * Set FontColourBlue value
     * @param int $fontColourBlue
     * @return \StructType\AddDesignerText
     */
    public function setFontColourBlue($fontColourBlue = null)
    {
        // validation for constraint: int
        if (!is_null($fontColourBlue) && !is_numeric($fontColourBlue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fontColourBlue)), __LINE__);
        }
        $this->FontColourBlue = $fontColourBlue;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\AddDesignerText
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AddDesignerText
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get PartDisplayName value
     * @return string|null
     */
    public function getPartDisplayName()
    {
        return $this->PartDisplayName;
    }
    /**
     * Set PartDisplayName value
     * @param string $partDisplayName
     * @return \StructType\AddDesignerText
     */
    public function setPartDisplayName($partDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($partDisplayName) && !is_string($partDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partDisplayName)), __LINE__);
        }
        $this->PartDisplayName = $partDisplayName;
        return $this;
    }
    /**
     * Get TextContent value
     * @return string|null
     */
    public function getTextContent()
    {
        return $this->TextContent;
    }
    /**
     * Set TextContent value
     * @param string $textContent
     * @return \StructType\AddDesignerText
     */
    public function setTextContent($textContent = null)
    {
        // validation for constraint: string
        if (!is_null($textContent) && !is_string($textContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textContent)), __LINE__);
        }
        $this->TextContent = $textContent;
        return $this;
    }
    /**
     * Get FontName value
     * @return string|null
     */
    public function getFontName()
    {
        return $this->FontName;
    }
    /**
     * Set FontName value
     * @param string $fontName
     * @return \StructType\AddDesignerText
     */
    public function setFontName($fontName = null)
    {
        // validation for constraint: string
        if (!is_null($fontName) && !is_string($fontName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fontName)), __LINE__);
        }
        $this->FontName = $fontName;
        return $this;
    }
    /**
     * Get TextJustification value
     * @return string|null
     */
    public function getTextJustification()
    {
        return $this->TextJustification;
    }
    /**
     * Set TextJustification value
     * @param string $textJustification
     * @return \StructType\AddDesignerText
     */
    public function setTextJustification($textJustification = null)
    {
        // validation for constraint: string
        if (!is_null($textJustification) && !is_string($textJustification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textJustification)), __LINE__);
        }
        $this->TextJustification = $textJustification;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\AddDesignerText
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddDesignerText
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
