<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddDesignerTemplate StructType
 * @subpackage Structs
 */
class AddDesignerTemplate extends AbstractStructBase
{
    /**
     * The MailingGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $MailingGUID;
    /**
     * The BleedSupplied
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $BleedSupplied;
    /**
     * The Copies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Copies;
    /**
     * The SkipPreviewImageGeneration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SkipPreviewImageGeneration;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The TemplateLayout
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateLayout;
    /**
     * The DocumentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentType;
    /**
     * The AddressFontCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressFontCode;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for AddDesignerTemplate
     * @uses AddDesignerTemplate::setMailingGUID()
     * @uses AddDesignerTemplate::setBleedSupplied()
     * @uses AddDesignerTemplate::setCopies()
     * @uses AddDesignerTemplate::setSkipPreviewImageGeneration()
     * @uses AddDesignerTemplate::setUsername()
     * @uses AddDesignerTemplate::setPassword()
     * @uses AddDesignerTemplate::setTemplateLayout()
     * @uses AddDesignerTemplate::setDocumentType()
     * @uses AddDesignerTemplate::setAddressFontCode()
     * @uses AddDesignerTemplate::setReturnFormat()
     * @param string $mailingGUID
     * @param bool $bleedSupplied
     * @param int $copies
     * @param bool $skipPreviewImageGeneration
     * @param string $username
     * @param string $password
     * @param string $templateLayout
     * @param string $documentType
     * @param string $addressFontCode
     * @param string $returnFormat
     */
    public function __construct($mailingGUID = null, $bleedSupplied = null, $copies = null, $skipPreviewImageGeneration = null, $username = null, $password = null, $templateLayout = null, $documentType = null, $addressFontCode = null, $returnFormat = null)
    {
        $this
            ->setMailingGUID($mailingGUID)
            ->setBleedSupplied($bleedSupplied)
            ->setCopies($copies)
            ->setSkipPreviewImageGeneration($skipPreviewImageGeneration)
            ->setUsername($username)
            ->setPassword($password)
            ->setTemplateLayout($templateLayout)
            ->setDocumentType($documentType)
            ->setAddressFontCode($addressFontCode)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get MailingGUID value
     * @return string
     */
    public function getMailingGUID()
    {
        return $this->MailingGUID;
    }
    /**
     * Set MailingGUID value
     * @param string $mailingGUID
     * @return \StructType\AddDesignerTemplate
     */
    public function setMailingGUID($mailingGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mailingGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($mailingGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mailingGUID) && !is_string($mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingGUID)), __LINE__);
        }
        $this->MailingGUID = $mailingGUID;
        return $this;
    }
    /**
     * Get BleedSupplied value
     * @return bool
     */
    public function getBleedSupplied()
    {
        return $this->BleedSupplied;
    }
    /**
     * Set BleedSupplied value
     * @param bool $bleedSupplied
     * @return \StructType\AddDesignerTemplate
     */
    public function setBleedSupplied($bleedSupplied = null)
    {
        // validation for constraint: boolean
        if (!is_null($bleedSupplied) && !is_bool($bleedSupplied)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($bleedSupplied)), __LINE__);
        }
        $this->BleedSupplied = $bleedSupplied;
        return $this;
    }
    /**
     * Get Copies value
     * @return int
     */
    public function getCopies()
    {
        return $this->Copies;
    }
    /**
     * Set Copies value
     * @param int $copies
     * @return \StructType\AddDesignerTemplate
     */
    public function setCopies($copies = null)
    {
        // validation for constraint: int
        if (!is_null($copies) && !is_numeric($copies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($copies)), __LINE__);
        }
        $this->Copies = $copies;
        return $this;
    }
    /**
     * Get SkipPreviewImageGeneration value
     * @return bool
     */
    public function getSkipPreviewImageGeneration()
    {
        return $this->SkipPreviewImageGeneration;
    }
    /**
     * Set SkipPreviewImageGeneration value
     * @param bool $skipPreviewImageGeneration
     * @return \StructType\AddDesignerTemplate
     */
    public function setSkipPreviewImageGeneration($skipPreviewImageGeneration = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipPreviewImageGeneration) && !is_bool($skipPreviewImageGeneration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($skipPreviewImageGeneration)), __LINE__);
        }
        $this->SkipPreviewImageGeneration = $skipPreviewImageGeneration;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\AddDesignerTemplate
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AddDesignerTemplate
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get TemplateLayout value
     * @return string|null
     */
    public function getTemplateLayout()
    {
        return $this->TemplateLayout;
    }
    /**
     * Set TemplateLayout value
     * @param string $templateLayout
     * @return \StructType\AddDesignerTemplate
     */
    public function setTemplateLayout($templateLayout = null)
    {
        // validation for constraint: string
        if (!is_null($templateLayout) && !is_string($templateLayout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($templateLayout)), __LINE__);
        }
        $this->TemplateLayout = $templateLayout;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param string $documentType
     * @return \StructType\AddDesignerTemplate
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get AddressFontCode value
     * @return string|null
     */
    public function getAddressFontCode()
    {
        return $this->AddressFontCode;
    }
    /**
     * Set AddressFontCode value
     * @param string $addressFontCode
     * @return \StructType\AddDesignerTemplate
     */
    public function setAddressFontCode($addressFontCode = null)
    {
        // validation for constraint: string
        if (!is_null($addressFontCode) && !is_string($addressFontCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressFontCode)), __LINE__);
        }
        $this->AddressFontCode = $addressFontCode;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\AddDesignerTemplate
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddDesignerTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
