<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddBackgroundFileToLibrary StructType
 * @subpackage Structs
 */
class AddBackgroundFileToLibrary extends AbstractStructBase
{
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The BackgroundName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BackgroundName;
    /**
     * The DocumentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentType;
    /**
     * The FileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * The FileData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileData;
    /**
     * The EncryptionPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EncryptionPassword;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for AddBackgroundFileToLibrary
     * @uses AddBackgroundFileToLibrary::setUsername()
     * @uses AddBackgroundFileToLibrary::setPassword()
     * @uses AddBackgroundFileToLibrary::setBackgroundName()
     * @uses AddBackgroundFileToLibrary::setDocumentType()
     * @uses AddBackgroundFileToLibrary::setFileName()
     * @uses AddBackgroundFileToLibrary::setFileData()
     * @uses AddBackgroundFileToLibrary::setEncryptionPassword()
     * @uses AddBackgroundFileToLibrary::setReturnFormat()
     * @param string $username
     * @param string $password
     * @param string $backgroundName
     * @param string $documentType
     * @param string $fileName
     * @param string $fileData
     * @param string $encryptionPassword
     * @param string $returnFormat
     */
    public function __construct($username = null, $password = null, $backgroundName = null, $documentType = null, $fileName = null, $fileData = null, $encryptionPassword = null, $returnFormat = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setBackgroundName($backgroundName)
            ->setDocumentType($documentType)
            ->setFileName($fileName)
            ->setFileData($fileData)
            ->setEncryptionPassword($encryptionPassword)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\AddBackgroundFileToLibrary
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AddBackgroundFileToLibrary
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get BackgroundName value
     * @return string|null
     */
    public function getBackgroundName()
    {
        return $this->BackgroundName;
    }
    /**
     * Set BackgroundName value
     * @param string $backgroundName
     * @return \StructType\AddBackgroundFileToLibrary
     */
    public function setBackgroundName($backgroundName = null)
    {
        // validation for constraint: string
        if (!is_null($backgroundName) && !is_string($backgroundName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($backgroundName)), __LINE__);
        }
        $this->BackgroundName = $backgroundName;
        return $this;
    }
    /**
     * Get DocumentType value
     * @return string|null
     */
    public function getDocumentType()
    {
        return $this->DocumentType;
    }
    /**
     * Set DocumentType value
     * @param string $documentType
     * @return \StructType\AddBackgroundFileToLibrary
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentType)), __LINE__);
        }
        $this->DocumentType = $documentType;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\AddBackgroundFileToLibrary
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Get FileData value
     * @return string|null
     */
    public function getFileData()
    {
        return $this->FileData;
    }
    /**
     * Set FileData value
     * @param string $fileData
     * @return \StructType\AddBackgroundFileToLibrary
     */
    public function setFileData($fileData = null)
    {
        // validation for constraint: string
        if (!is_null($fileData) && !is_string($fileData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileData)), __LINE__);
        }
        $this->FileData = $fileData;
        return $this;
    }
    /**
     * Get EncryptionPassword value
     * @return string|null
     */
    public function getEncryptionPassword()
    {
        return $this->EncryptionPassword;
    }
    /**
     * Set EncryptionPassword value
     * @param string $encryptionPassword
     * @return \StructType\AddBackgroundFileToLibrary
     */
    public function setEncryptionPassword($encryptionPassword = null)
    {
        // validation for constraint: string
        if (!is_null($encryptionPassword) && !is_string($encryptionPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($encryptionPassword)), __LINE__);
        }
        $this->EncryptionPassword = $encryptionPassword;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\AddBackgroundFileToLibrary
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddBackgroundFileToLibrary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
