<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ListMailings
     * Meta informations extracted from the WSDL
     * - documentation: Get a list of mailings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMailings $parameters
     * @return \StructType\ListMailingsResponse|bool
     */
    public function ListMailings(\StructType\ListMailings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListMailings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListMailingsPageCount
     * Meta informations extracted from the WSDL
     * - documentation: Get the count of pages for a list of mailings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMailingsPageCount $parameters
     * @return \StructType\ListMailingsPageCountResponse|bool
     */
    public function ListMailingsPageCount(\StructType\ListMailingsPageCount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListMailingsPageCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListLibraryTemplates
     * Meta informations extracted from the WSDL
     * - documentation: Get a list of library templates or inserts.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLibraryTemplates $parameters
     * @return \StructType\ListLibraryTemplatesResponse|bool
     */
    public function ListLibraryTemplates(\StructType\ListLibraryTemplates $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListLibraryTemplates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListLibraryTemplatesPageCount
     * Meta informations extracted from the WSDL
     * - documentation: Get the count of pages for a list of library templates or inserts.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLibraryTemplatesPageCount $parameters
     * @return \StructType\ListLibraryTemplatesPageCountResponse|bool
     */
    public function ListLibraryTemplatesPageCount(\StructType\ListLibraryTemplatesPageCount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListLibraryTemplatesPageCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListLibraryBackgrounds
     * Meta informations extracted from the WSDL
     * - documentation: Get a list of library backgrounds.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLibraryBackgrounds $parameters
     * @return \StructType\ListLibraryBackgroundsResponse|bool
     */
    public function ListLibraryBackgrounds(\StructType\ListLibraryBackgrounds $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListLibraryBackgrounds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListLibraryBackgroundsPageCount
     * Meta informations extracted from the WSDL
     * - documentation: Get the count of pages for a list of library backgrounds.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLibraryBackgroundsPageCount $parameters
     * @return \StructType\ListLibraryBackgroundsPageCountResponse|bool
     */
    public function ListLibraryBackgroundsPageCount(\StructType\ListLibraryBackgroundsPageCount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListLibraryBackgroundsPageCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListLibraryMailPacks
     * Meta informations extracted from the WSDL
     * - documentation: Get a list of library mail packs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLibraryMailPacks $parameters
     * @return \StructType\ListLibraryMailPacksResponse|bool
     */
    public function ListLibraryMailPacks(\StructType\ListLibraryMailPacks $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListLibraryMailPacks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListLibraryMailPacksPageCount
     * Meta informations extracted from the WSDL
     * - documentation: Get the count of pages for a list of library mail packs.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLibraryMailPacksPageCount $parameters
     * @return \StructType\ListLibraryMailPacksPageCountResponse|bool
     */
    public function ListLibraryMailPacksPageCount(\StructType\ListLibraryMailPacksPageCount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListLibraryMailPacksPageCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListLibraryMailingLists
     * Meta informations extracted from the WSDL
     * - documentation: Get a list of library mailing lists.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLibraryMailingLists $parameters
     * @return \StructType\ListLibraryMailingListsResponse|bool
     */
    public function ListLibraryMailingLists(\StructType\ListLibraryMailingLists $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListLibraryMailingLists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListLibraryMailingListsPageCount
     * Meta informations extracted from the WSDL
     * - documentation: Get the count of pages for a list of library mailing lists.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListLibraryMailingListsPageCount $parameters
     * @return \StructType\ListLibraryMailingListsPageCountResponse|bool
     */
    public function ListLibraryMailingListsPageCount(\StructType\ListLibraryMailingListsPageCount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListLibraryMailingListsPageCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListMailingFilterCategories
     * Meta informations extracted from the WSDL
     * - documentation: Get a list of mailing filter categories. For use by corporate accounts only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMailingFilterCategories $parameters
     * @return \StructType\ListMailingFilterCategoriesResponse|bool
     */
    public function ListMailingFilterCategories(\StructType\ListMailingFilterCategories $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListMailingFilterCategories($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListMailingFiltersForCategory
     * Meta informations extracted from the WSDL
     * - documentation: Get a list of mailing filter values for a given category. For use by corporate accounts only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMailingFiltersForCategory $parameters
     * @return \StructType\ListMailingFiltersForCategoryResponse|bool
     */
    public function ListMailingFiltersForCategory(\StructType\ListMailingFiltersForCategory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListMailingFiltersForCategory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListTemplateVariables
     * Meta informations extracted from the WSDL
     * - documentation: Get a list of template variables for a given template.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListTemplateVariables $parameters
     * @return \StructType\ListTemplateVariablesResponse|bool
     */
    public function ListTemplateVariables(\StructType\ListTemplateVariables $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListTemplateVariables($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListMailingVariableValues
     * Meta informations extracted from the WSDL
     * - documentation: Get a list of template variable values. For use by corporate accounts only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListMailingVariableValues $parameters
     * @return \StructType\ListMailingVariableValuesResponse|bool
     */
    public function ListMailingVariableValues(\StructType\ListMailingVariableValues $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListMailingVariableValues($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListProductTypes
     * Meta informations extracted from the WSDL
     * - documentation: Get a list of product types.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListProductTypes $parameters
     * @return \StructType\ListProductTypesResponse|bool
     */
    public function ListProductTypes(\StructType\ListProductTypes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListProductTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListDocumentTypes
     * Meta informations extracted from the WSDL
     * - documentation: Get a list of document types for a product type.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDocumentTypes $parameters
     * @return \StructType\ListDocumentTypesResponse|bool
     */
    public function ListDocumentTypes(\StructType\ListDocumentTypes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListDocumentTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListDocumentTypesResponse|\StructType\ListLibraryBackgroundsPageCountResponse|\StructType\ListLibraryBackgroundsResponse|\StructType\ListLibraryMailingListsPageCountResponse|\StructType\ListLibraryMailingListsResponse|\StructType\ListLibraryMailPacksPageCountResponse|\StructType\ListLibraryMailPacksResponse|\StructType\ListLibraryTemplatesPageCountResponse|\StructType\ListLibraryTemplatesResponse|\StructType\ListMailingFilterCategoriesResponse|\StructType\ListMailingFiltersForCategoryResponse|\StructType\ListMailingsPageCountResponse|\StructType\ListMailingsResponse|\StructType\ListMailingVariableValuesResponse|\StructType\ListProductTypesResponse|\StructType\ListTemplateVariablesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
