<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetTemplateImage
     * Meta informations extracted from the WSDL
     * - documentation: Get the template preview image. Supply 0 for the page to get an index image.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTemplateImage $parameters
     * @return \StructType\GetTemplateImageResponse|bool
     */
    public function GetTemplateImage(\StructType\GetTemplateImage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTemplateImage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailingDetails
     * Meta informations extracted from the WSDL
     * - documentation: Get details of the mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMailingDetails $parameters
     * @return \StructType\GetMailingDetailsResponse|bool
     */
    public function GetMailingDetails(\StructType\GetMailingDetails $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMailingDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStatus
     * Meta informations extracted from the WSDL
     * - documentation: Get the current status of the auto mailing process.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStatus $parameters
     * @return \StructType\GetStatusResponse|bool
     */
    public function GetStatus(\StructType\GetStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProofFile
     * Meta informations extracted from the WSDL
     * - documentation: Get the mailing PDF proof file.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProofFile $parameters
     * @return \StructType\GetProofFileResponse|bool
     */
    public function GetProofFile(\StructType\GetProofFile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProofFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProofImage
     * Meta informations extracted from the WSDL
     * - documentation: Get the mailing proof image for a given page. Supply 0 for the page to get an index image.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProofImage $parameters
     * @return \StructType\GetProofImageResponse|bool
     */
    public function GetProofImage(\StructType\GetProofImage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProofImage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBalance
     * Meta informations extracted from the WSDL
     * - documentation: Get the current account balance.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBalance $parameters
     * @return \StructType\GetBalanceResponse|bool
     */
    public function GetBalance(\StructType\GetBalance $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBalance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailingGUIDFromOrderRef
     * Meta informations extracted from the WSDL
     * - documentation: Get the Mailing GUID from the Order Ref.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMailingGUIDFromOrderRef $parameters
     * @return \StructType\GetMailingGUIDFromOrderRefResponse|bool
     */
    public function GetMailingGUIDFromOrderRef(\StructType\GetMailingGUIDFromOrderRef $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMailingGUIDFromOrderRef($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailingPriceEstimate
     * Meta informations extracted from the WSDL
     * - documentation: Get price estimate for a mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMailingPriceEstimate $parameters
     * @return \StructType\GetMailingPriceEstimateResponse|bool
     */
    public function GetMailingPriceEstimate(\StructType\GetMailingPriceEstimate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMailingPriceEstimate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPriceEstimate
     * Meta informations extracted from the WSDL
     * - documentation: Get price estimate for specified data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPriceEstimate $parameters
     * @return \StructType\GetPriceEstimateResponse|bool
     */
    public function GetPriceEstimate(\StructType\GetPriceEstimate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPriceEstimate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailPackZip
     * Meta informations extracted from the WSDL
     * - documentation: Get the mail pack templates in a zip file.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMailPackZip $parameters
     * @return \StructType\GetMailPackZipResponse|bool
     */
    public function GetMailPackZip(\StructType\GetMailPackZip $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMailPackZip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMailingListZip
     * Meta informations extracted from the WSDL
     * - documentation: Get the mailing list in a zip file. Only returns data once the mailing has been submitted.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMailingListZip $parameters
     * @return \StructType\GetMailingListZipResponse|bool
     */
    public function GetMailingListZip(\StructType\GetMailingListZip $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMailingListZip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetBalanceResponse|\StructType\GetMailingDetailsResponse|\StructType\GetMailingGUIDFromOrderRefResponse|\StructType\GetMailingListZipResponse|\StructType\GetMailingPriceEstimateResponse|\StructType\GetMailPackZipResponse|\StructType\GetPriceEstimateResponse|\StructType\GetProofFileResponse|\StructType\GetProofImageResponse|\StructType\GetStatusResponse|\StructType\GetTemplateImageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
