<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeleteMailing
     * Meta informations extracted from the WSDL
     * - documentation: Delete a mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteMailing $parameters
     * @return \StructType\DeleteMailingResponse|bool
     */
    public function DeleteMailing(\StructType\DeleteMailing $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteTemplate
     * Meta informations extracted from the WSDL
     * - documentation: Delete a template from a mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteTemplate $parameters
     * @return \StructType\DeleteTemplateResponse|bool
     */
    public function DeleteTemplate(\StructType\DeleteTemplate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteMailPack
     * Meta informations extracted from the WSDL
     * - documentation: Delete the mail pack from a mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteMailPack $parameters
     * @return \StructType\DeleteMailPackResponse|bool
     */
    public function DeleteMailPack(\StructType\DeleteMailPack $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteMailingList
     * Meta informations extracted from the WSDL
     * - documentation: Delete the mailing list from a mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteMailingList $parameters
     * @return \StructType\DeleteMailingListResponse|bool
     */
    public function DeleteMailingList(\StructType\DeleteMailingList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteMailingList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeleteMailingListResponse|\StructType\DeleteMailingResponse|\StructType\DeleteMailPackResponse|\StructType\DeleteTemplateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
