<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateFileMailing
     * Meta informations extracted from the WSDL
     * - documentation: Create mailings from a zip file. Include an XML file to control the mailings referencing DMWS.xsd for the schema information.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateFileMailing $parameters
     * @return \StructType\CreateFileMailingResponse|bool
     */
    public function CreateFileMailing(\StructType\CreateFileMailing $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateFileMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateMailing
     * Meta informations extracted from the WSDL
     * - documentation: Create a mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateMailing $parameters
     * @return \StructType\CreateMailingResponse|bool
     */
    public function CreateMailing(\StructType\CreateMailing $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAccount
     * Meta informations extracted from the WSDL
     * - documentation: Create an Account. Please contact the support team to obtain permission to use this function.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateAccount $parameters
     * @return \StructType\CreateAccountResponse|bool
     */
    public function CreateAccount(\StructType\CreateAccount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreateAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateAccountResponse|\StructType\CreateFileMailingResponse|\StructType\CreateMailingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
