<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Auto ServiceType
 * @subpackage Services
 */
class Auto extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AutoCorrectAddresses
     * Meta informations extracted from the WSDL
     * - documentation: Auto correct all the addresses added to the mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AutoCorrectAddresses $parameters
     * @return \StructType\AutoCorrectAddressesResponse|bool
     */
    public function AutoCorrectAddresses(\StructType\AutoCorrectAddresses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AutoCorrectAddresses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AutoCorrectAddressesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
