<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.cfhdocmail.com/TestAPI2/DMWS.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.cfhdocmail.com/TestAPI2/DMWS.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateFileMailing operation/method
 */
if ($create->CreateFileMailing(new \StructType\CreateFileMailing()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateMailing operation/method
 */
if ($create->CreateMailing(new \StructType\CreateMailing()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAccount operation/method
 */
if ($create->CreateAccount(new \StructType\CreateAccount()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddMailingFilter operation/method
 */
if ($add->AddMailingFilter(new \StructType\AddMailingFilter()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDeliveryAddress operation/method
 */
if ($add->AddDeliveryAddress(new \StructType\AddDeliveryAddress()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTemplateFile operation/method
 */
if ($add->AddTemplateFile(new \StructType\AddTemplateFile()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTemplateBackgroundFile operation/method
 */
if ($add->AddTemplateBackgroundFile(new \StructType\AddTemplateBackgroundFile()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTemplateFromLibrary operation/method
 */
if ($add->AddTemplateFromLibrary(new \StructType\AddTemplateFromLibrary()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTemplateFromOrder operation/method
 */
if ($add->AddTemplateFromOrder(new \StructType\AddTemplateFromOrder()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMailPackFromLibrary operation/method
 */
if ($add->AddMailPackFromLibrary(new \StructType\AddMailPackFromLibrary()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMailPackFromOrder operation/method
 */
if ($add->AddMailPackFromOrder(new \StructType\AddMailPackFromOrder()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDesignerTemplate operation/method
 */
if ($add->AddDesignerTemplate(new \StructType\AddDesignerTemplate()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDesignerImage operation/method
 */
if ($add->AddDesignerImage(new \StructType\AddDesignerImage()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDesignerStoredImage operation/method
 */
if ($add->AddDesignerStoredImage(new \StructType\AddDesignerStoredImage()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDesignerText operation/method
 */
if ($add->AddDesignerText(new \StructType\AddDesignerText()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTemplateUseRule operation/method
 */
if ($add->AddTemplateUseRule(new \StructType\AddTemplateUseRule()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTemplateBackgroundRule operation/method
 */
if ($add->AddTemplateBackgroundRule(new \StructType\AddTemplateBackgroundRule()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMailingListFile operation/method
 */
if ($add->AddMailingListFile(new \StructType\AddMailingListFile()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMailingListString operation/method
 */
if ($add->AddMailingListString(new \StructType\AddMailingListString()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMailingListFromLibrary operation/method
 */
if ($add->AddMailingListFromLibrary(new \StructType\AddMailingListFromLibrary()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMailingListFromOrder operation/method
 */
if ($add->AddMailingListFromOrder(new \StructType\AddMailingListFromOrder()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddAddress operation/method
 */
if ($add->AddAddress(new \StructType\AddAddress()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSelf operation/method
 */
if ($add->AddSelf(new \StructType\AddSelf()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUser operation/method
 */
if ($add->AddUser(new \StructType\AddUser()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUserOrganisationStructureLink operation/method
 */
if ($add->AddUserOrganisationStructureLink(new \StructType\AddUserOrganisationStructureLink()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUserSignupData operation/method
 */
if ($add->AddUserSignupData(new \StructType\AddUserSignupData()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMailingListFileToLibrary operation/method
 */
if ($add->AddMailingListFileToLibrary(new \StructType\AddMailingListFileToLibrary()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMailingListStringToLibrary operation/method
 */
if ($add->AddMailingListStringToLibrary(new \StructType\AddMailingListStringToLibrary()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTemplateFileToLibrary operation/method
 */
if ($add->AddTemplateFileToLibrary(new \StructType\AddTemplateFileToLibrary()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddBackgroundFileToLibrary operation/method
 */
if ($add->AddBackgroundFileToLibrary(new \StructType\AddBackgroundFileToLibrary()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMailPackToLibrary operation/method
 */
if ($add->AddMailPackToLibrary(new \StructType\AddMailPackToLibrary()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTemplateToLibraryMailPack operation/method
 */
if ($add->AddTemplateToLibraryMailPack(new \StructType\AddTemplateToLibraryMailPack()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMailingListStringForAddressCount operation/method
 */
if ($add->AddMailingListStringForAddressCount(new \StructType\AddMailingListStringForAddressCount()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMailingListFileForAddressCount operation/method
 */
if ($add->AddMailingListFileForAddressCount(new \StructType\AddMailingListFileForAddressCount()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateMailingOptions operation/method
 */
if ($update->UpdateMailingOptions(new \StructType\UpdateMailingOptions()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetMailPackVariableValue operation/method
 */
if ($set->SetMailPackVariableValue(new \StructType\SetMailPackVariableValue()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetTemplateVariableValue operation/method
 */
if ($set->SetTemplateVariableValue(new \StructType\SetTemplateVariableValue()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetMailingListProofOption operation/method
 */
if ($set->SetMailingListProofOption(new \StructType\SetMailingListProofOption()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Auto ServiceType
 */
$auto = new \ServiceType\Auto($options);
/**
 * Sample call for AutoCorrectAddresses operation/method
 */
if ($auto->AutoCorrectAddresses(new \StructType\AutoCorrectAddresses()) !== false) {
    print_r($auto->getResult());
} else {
    print_r($auto->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for CancelMailing operation/method
 */
if ($cancel->CancelMailing(new \StructType\CancelMailing()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for CancelMailingApproval operation/method
 */
if ($cancel->CancelMailingApproval(new \StructType\CancelMailingApproval()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteMailing operation/method
 */
if ($delete->DeleteMailing(new \StructType\DeleteMailing()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteTemplate operation/method
 */
if ($delete->DeleteTemplate(new \StructType\DeleteTemplate()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteMailPack operation/method
 */
if ($delete->DeleteMailPack(new \StructType\DeleteMailPack()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteMailingList operation/method
 */
if ($delete->DeleteMailingList(new \StructType\DeleteMailingList()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetTemplateImage operation/method
 */
if ($get->GetTemplateImage(new \StructType\GetTemplateImage()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMailingDetails operation/method
 */
if ($get->GetMailingDetails(new \StructType\GetMailingDetails()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStatus operation/method
 */
if ($get->GetStatus(new \StructType\GetStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProofFile operation/method
 */
if ($get->GetProofFile(new \StructType\GetProofFile()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProofImage operation/method
 */
if ($get->GetProofImage(new \StructType\GetProofImage()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBalance operation/method
 */
if ($get->GetBalance(new \StructType\GetBalance()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMailingGUIDFromOrderRef operation/method
 */
if ($get->GetMailingGUIDFromOrderRef(new \StructType\GetMailingGUIDFromOrderRef()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMailingPriceEstimate operation/method
 */
if ($get->GetMailingPriceEstimate(new \StructType\GetMailingPriceEstimate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPriceEstimate operation/method
 */
if ($get->GetPriceEstimate(new \StructType\GetPriceEstimate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMailPackZip operation/method
 */
if ($get->GetMailPackZip(new \StructType\GetMailPackZip()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMailingListZip operation/method
 */
if ($get->GetMailingListZip(new \StructType\GetMailingListZip()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Process ServiceType
 */
$process = new \ServiceType\Process($options);
/**
 * Sample call for ProcessMailing operation/method
 */
if ($process->ProcessMailing(new \StructType\ProcessMailing()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Samples for User ServiceType
 */
$user = new \ServiceType\User($options);
/**
 * Sample call for UserApproveMailing operation/method
 */
if ($user->UserApproveMailing(new \StructType\UserApproveMailing()) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \ServiceType\_List($options);
/**
 * Sample call for ListMailings operation/method
 */
if ($list->ListMailings(new \StructType\ListMailings()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListMailingsPageCount operation/method
 */
if ($list->ListMailingsPageCount(new \StructType\ListMailingsPageCount()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListLibraryTemplates operation/method
 */
if ($list->ListLibraryTemplates(new \StructType\ListLibraryTemplates()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListLibraryTemplatesPageCount operation/method
 */
if ($list->ListLibraryTemplatesPageCount(new \StructType\ListLibraryTemplatesPageCount()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListLibraryBackgrounds operation/method
 */
if ($list->ListLibraryBackgrounds(new \StructType\ListLibraryBackgrounds()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListLibraryBackgroundsPageCount operation/method
 */
if ($list->ListLibraryBackgroundsPageCount(new \StructType\ListLibraryBackgroundsPageCount()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListLibraryMailPacks operation/method
 */
if ($list->ListLibraryMailPacks(new \StructType\ListLibraryMailPacks()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListLibraryMailPacksPageCount operation/method
 */
if ($list->ListLibraryMailPacksPageCount(new \StructType\ListLibraryMailPacksPageCount()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListLibraryMailingLists operation/method
 */
if ($list->ListLibraryMailingLists(new \StructType\ListLibraryMailingLists()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListLibraryMailingListsPageCount operation/method
 */
if ($list->ListLibraryMailingListsPageCount(new \StructType\ListLibraryMailingListsPageCount()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListMailingFilterCategories operation/method
 */
if ($list->ListMailingFilterCategories(new \StructType\ListMailingFilterCategories()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListMailingFiltersForCategory operation/method
 */
if ($list->ListMailingFiltersForCategory(new \StructType\ListMailingFiltersForCategory()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListTemplateVariables operation/method
 */
if ($list->ListTemplateVariables(new \StructType\ListTemplateVariables()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListMailingVariableValues operation/method
 */
if ($list->ListMailingVariableValues(new \StructType\ListMailingVariableValues()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListProductTypes operation/method
 */
if ($list->ListProductTypes(new \StructType\ListProductTypes()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListDocumentTypes operation/method
 */
if ($list->ListDocumentTypes(new \StructType\ListDocumentTypes()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Poll ServiceType
 */
$poll = new \ServiceType\Poll($options);
/**
 * Sample call for PollMailingListAddressCounts operation/method
 */
if ($poll->PollMailingListAddressCounts(new \StructType\PollMailingListAddressCounts()) !== false) {
    print_r($poll->getResult());
} else {
    print_r($poll->getLastError());
}
/**
 * Samples for Extended ServiceType
 */
$extended = new \ServiceType\Extended($options);
/**
 * Sample call for ExtendedCall operation/method
 */
if ($extended->ExtendedCall(new \StructType\ExtendedCall()) !== false) {
    print_r($extended->getResult());
} else {
    print_r($extended->getLastError());
}
/**
 * Sample call for ExtendedCallDefinition operation/method
 */
if ($extended->ExtendedCallDefinition(new \StructType\ExtendedCallDefinition()) !== false) {
    print_r($extended->getResult());
} else {
    print_r($extended->getLastError());
}
