<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMailingOptions StructType
 * @subpackage Structs
 */
class UpdateMailingOptions extends AbstractStructBase
{
    /**
     * The MailingGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $MailingGUID;
    /**
     * The IsMono
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMono;
    /**
     * The IsDuplex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDuplex;
    /**
     * The DespatchASAP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DespatchASAP;
    /**
     * The DespatchDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DespatchDate;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The MailingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailingName;
    /**
     * The MailingDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailingDescription;
    /**
     * The DeliveryType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryType;
    /**
     * The AddressNamePrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressNamePrefix;
    /**
     * The AddressNameFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressNameFormat;
    /**
     * The DiscountCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DiscountCode;
    /**
     * The MinEnvelopeSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MinEnvelopeSize;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for UpdateMailingOptions
     * @uses UpdateMailingOptions::setMailingGUID()
     * @uses UpdateMailingOptions::setIsMono()
     * @uses UpdateMailingOptions::setIsDuplex()
     * @uses UpdateMailingOptions::setDespatchASAP()
     * @uses UpdateMailingOptions::setDespatchDate()
     * @uses UpdateMailingOptions::setUsername()
     * @uses UpdateMailingOptions::setPassword()
     * @uses UpdateMailingOptions::setMailingName()
     * @uses UpdateMailingOptions::setMailingDescription()
     * @uses UpdateMailingOptions::setDeliveryType()
     * @uses UpdateMailingOptions::setAddressNamePrefix()
     * @uses UpdateMailingOptions::setAddressNameFormat()
     * @uses UpdateMailingOptions::setDiscountCode()
     * @uses UpdateMailingOptions::setMinEnvelopeSize()
     * @uses UpdateMailingOptions::setReturnFormat()
     * @param string $mailingGUID
     * @param bool $isMono
     * @param bool $isDuplex
     * @param bool $despatchASAP
     * @param string $despatchDate
     * @param string $username
     * @param string $password
     * @param string $mailingName
     * @param string $mailingDescription
     * @param string $deliveryType
     * @param string $addressNamePrefix
     * @param string $addressNameFormat
     * @param string $discountCode
     * @param string $minEnvelopeSize
     * @param string $returnFormat
     */
    public function __construct($mailingGUID = null, $isMono = null, $isDuplex = null, $despatchASAP = null, $despatchDate = null, $username = null, $password = null, $mailingName = null, $mailingDescription = null, $deliveryType = null, $addressNamePrefix = null, $addressNameFormat = null, $discountCode = null, $minEnvelopeSize = null, $returnFormat = null)
    {
        $this
            ->setMailingGUID($mailingGUID)
            ->setIsMono($isMono)
            ->setIsDuplex($isDuplex)
            ->setDespatchASAP($despatchASAP)
            ->setDespatchDate($despatchDate)
            ->setUsername($username)
            ->setPassword($password)
            ->setMailingName($mailingName)
            ->setMailingDescription($mailingDescription)
            ->setDeliveryType($deliveryType)
            ->setAddressNamePrefix($addressNamePrefix)
            ->setAddressNameFormat($addressNameFormat)
            ->setDiscountCode($discountCode)
            ->setMinEnvelopeSize($minEnvelopeSize)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get MailingGUID value
     * @return string
     */
    public function getMailingGUID()
    {
        return $this->MailingGUID;
    }
    /**
     * Set MailingGUID value
     * @param string $mailingGUID
     * @return \StructType\UpdateMailingOptions
     */
    public function setMailingGUID($mailingGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mailingGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($mailingGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mailingGUID) && !is_string($mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingGUID)), __LINE__);
        }
        $this->MailingGUID = $mailingGUID;
        return $this;
    }
    /**
     * Get IsMono value
     * @return bool
     */
    public function getIsMono()
    {
        return $this->IsMono;
    }
    /**
     * Set IsMono value
     * @param bool $isMono
     * @return \StructType\UpdateMailingOptions
     */
    public function setIsMono($isMono = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMono) && !is_bool($isMono)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMono)), __LINE__);
        }
        $this->IsMono = $isMono;
        return $this;
    }
    /**
     * Get IsDuplex value
     * @return bool
     */
    public function getIsDuplex()
    {
        return $this->IsDuplex;
    }
    /**
     * Set IsDuplex value
     * @param bool $isDuplex
     * @return \StructType\UpdateMailingOptions
     */
    public function setIsDuplex($isDuplex = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDuplex) && !is_bool($isDuplex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDuplex)), __LINE__);
        }
        $this->IsDuplex = $isDuplex;
        return $this;
    }
    /**
     * Get DespatchASAP value
     * @return bool
     */
    public function getDespatchASAP()
    {
        return $this->DespatchASAP;
    }
    /**
     * Set DespatchASAP value
     * @param bool $despatchASAP
     * @return \StructType\UpdateMailingOptions
     */
    public function setDespatchASAP($despatchASAP = null)
    {
        // validation for constraint: boolean
        if (!is_null($despatchASAP) && !is_bool($despatchASAP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($despatchASAP)), __LINE__);
        }
        $this->DespatchASAP = $despatchASAP;
        return $this;
    }
    /**
     * Get DespatchDate value
     * @return string
     */
    public function getDespatchDate()
    {
        return $this->DespatchDate;
    }
    /**
     * Set DespatchDate value
     * @param string $despatchDate
     * @return \StructType\UpdateMailingOptions
     */
    public function setDespatchDate($despatchDate = null)
    {
        // validation for constraint: string
        if (!is_null($despatchDate) && !is_string($despatchDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($despatchDate)), __LINE__);
        }
        $this->DespatchDate = $despatchDate;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\UpdateMailingOptions
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\UpdateMailingOptions
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get MailingName value
     * @return string|null
     */
    public function getMailingName()
    {
        return $this->MailingName;
    }
    /**
     * Set MailingName value
     * @param string $mailingName
     * @return \StructType\UpdateMailingOptions
     */
    public function setMailingName($mailingName = null)
    {
        // validation for constraint: string
        if (!is_null($mailingName) && !is_string($mailingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingName)), __LINE__);
        }
        $this->MailingName = $mailingName;
        return $this;
    }
    /**
     * Get MailingDescription value
     * @return string|null
     */
    public function getMailingDescription()
    {
        return $this->MailingDescription;
    }
    /**
     * Set MailingDescription value
     * @param string $mailingDescription
     * @return \StructType\UpdateMailingOptions
     */
    public function setMailingDescription($mailingDescription = null)
    {
        // validation for constraint: string
        if (!is_null($mailingDescription) && !is_string($mailingDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingDescription)), __LINE__);
        }
        $this->MailingDescription = $mailingDescription;
        return $this;
    }
    /**
     * Get DeliveryType value
     * @return string|null
     */
    public function getDeliveryType()
    {
        return $this->DeliveryType;
    }
    /**
     * Set DeliveryType value
     * @param string $deliveryType
     * @return \StructType\UpdateMailingOptions
     */
    public function setDeliveryType($deliveryType = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryType) && !is_string($deliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryType)), __LINE__);
        }
        $this->DeliveryType = $deliveryType;
        return $this;
    }
    /**
     * Get AddressNamePrefix value
     * @return string|null
     */
    public function getAddressNamePrefix()
    {
        return $this->AddressNamePrefix;
    }
    /**
     * Set AddressNamePrefix value
     * @param string $addressNamePrefix
     * @return \StructType\UpdateMailingOptions
     */
    public function setAddressNamePrefix($addressNamePrefix = null)
    {
        // validation for constraint: string
        if (!is_null($addressNamePrefix) && !is_string($addressNamePrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressNamePrefix)), __LINE__);
        }
        $this->AddressNamePrefix = $addressNamePrefix;
        return $this;
    }
    /**
     * Get AddressNameFormat value
     * @return string|null
     */
    public function getAddressNameFormat()
    {
        return $this->AddressNameFormat;
    }
    /**
     * Set AddressNameFormat value
     * @param string $addressNameFormat
     * @return \StructType\UpdateMailingOptions
     */
    public function setAddressNameFormat($addressNameFormat = null)
    {
        // validation for constraint: string
        if (!is_null($addressNameFormat) && !is_string($addressNameFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressNameFormat)), __LINE__);
        }
        $this->AddressNameFormat = $addressNameFormat;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return string|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param string $discountCode
     * @return \StructType\UpdateMailingOptions
     */
    public function setDiscountCode($discountCode = null)
    {
        // validation for constraint: string
        if (!is_null($discountCode) && !is_string($discountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discountCode)), __LINE__);
        }
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get MinEnvelopeSize value
     * @return string|null
     */
    public function getMinEnvelopeSize()
    {
        return $this->MinEnvelopeSize;
    }
    /**
     * Set MinEnvelopeSize value
     * @param string $minEnvelopeSize
     * @return \StructType\UpdateMailingOptions
     */
    public function setMinEnvelopeSize($minEnvelopeSize = null)
    {
        // validation for constraint: string
        if (!is_null($minEnvelopeSize) && !is_string($minEnvelopeSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minEnvelopeSize)), __LINE__);
        }
        $this->MinEnvelopeSize = $minEnvelopeSize;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\UpdateMailingOptions
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateMailingOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
