<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ListLibraryMailPacks StructType
 * @subpackage Structs
 */
class ListLibraryMailPacks extends AbstractStructBase
{
    /**
     * The PageSize
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageSize;
    /**
     * The PageNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageNumber;
    /**
     * The SortDescending
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SortDescending;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The ProductType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductType;
    /**
     * The SearchText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SearchText;
    /**
     * The SortColumn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SortColumn;
    /**
     * The ListFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ListFormat;
    /**
     * The FailureReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FailureReturnFormat;
    /**
     * Constructor method for ListLibraryMailPacks
     * @uses ListLibraryMailPacks::setPageSize()
     * @uses ListLibraryMailPacks::setPageNumber()
     * @uses ListLibraryMailPacks::setSortDescending()
     * @uses ListLibraryMailPacks::setUsername()
     * @uses ListLibraryMailPacks::setPassword()
     * @uses ListLibraryMailPacks::setProductType()
     * @uses ListLibraryMailPacks::setSearchText()
     * @uses ListLibraryMailPacks::setSortColumn()
     * @uses ListLibraryMailPacks::setListFormat()
     * @uses ListLibraryMailPacks::setFailureReturnFormat()
     * @param int $pageSize
     * @param int $pageNumber
     * @param bool $sortDescending
     * @param string $username
     * @param string $password
     * @param string $productType
     * @param string $searchText
     * @param string $sortColumn
     * @param string $listFormat
     * @param string $failureReturnFormat
     */
    public function __construct($pageSize = null, $pageNumber = null, $sortDescending = null, $username = null, $password = null, $productType = null, $searchText = null, $sortColumn = null, $listFormat = null, $failureReturnFormat = null)
    {
        $this
            ->setPageSize($pageSize)
            ->setPageNumber($pageNumber)
            ->setSortDescending($sortDescending)
            ->setUsername($username)
            ->setPassword($password)
            ->setProductType($productType)
            ->setSearchText($searchText)
            ->setSortColumn($sortColumn)
            ->setListFormat($listFormat)
            ->setFailureReturnFormat($failureReturnFormat);
    }
    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param int $pageSize
     * @return \StructType\ListLibraryMailPacks
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !is_numeric($pageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get PageNumber value
     * @return int
     */
    public function getPageNumber()
    {
        return $this->PageNumber;
    }
    /**
     * Set PageNumber value
     * @param int $pageNumber
     * @return \StructType\ListLibraryMailPacks
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !is_numeric($pageNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageNumber)), __LINE__);
        }
        $this->PageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get SortDescending value
     * @return bool
     */
    public function getSortDescending()
    {
        return $this->SortDescending;
    }
    /**
     * Set SortDescending value
     * @param bool $sortDescending
     * @return \StructType\ListLibraryMailPacks
     */
    public function setSortDescending($sortDescending = null)
    {
        // validation for constraint: boolean
        if (!is_null($sortDescending) && !is_bool($sortDescending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sortDescending)), __LINE__);
        }
        $this->SortDescending = $sortDescending;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\ListLibraryMailPacks
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\ListLibraryMailPacks
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @param string $productType
     * @return \StructType\ListLibraryMailPacks
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productType)), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get SearchText value
     * @return string|null
     */
    public function getSearchText()
    {
        return $this->SearchText;
    }
    /**
     * Set SearchText value
     * @param string $searchText
     * @return \StructType\ListLibraryMailPacks
     */
    public function setSearchText($searchText = null)
    {
        // validation for constraint: string
        if (!is_null($searchText) && !is_string($searchText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchText)), __LINE__);
        }
        $this->SearchText = $searchText;
        return $this;
    }
    /**
     * Get SortColumn value
     * @return string|null
     */
    public function getSortColumn()
    {
        return $this->SortColumn;
    }
    /**
     * Set SortColumn value
     * @param string $sortColumn
     * @return \StructType\ListLibraryMailPacks
     */
    public function setSortColumn($sortColumn = null)
    {
        // validation for constraint: string
        if (!is_null($sortColumn) && !is_string($sortColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sortColumn)), __LINE__);
        }
        $this->SortColumn = $sortColumn;
        return $this;
    }
    /**
     * Get ListFormat value
     * @return string|null
     */
    public function getListFormat()
    {
        return $this->ListFormat;
    }
    /**
     * Set ListFormat value
     * @param string $listFormat
     * @return \StructType\ListLibraryMailPacks
     */
    public function setListFormat($listFormat = null)
    {
        // validation for constraint: string
        if (!is_null($listFormat) && !is_string($listFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listFormat)), __LINE__);
        }
        $this->ListFormat = $listFormat;
        return $this;
    }
    /**
     * Get FailureReturnFormat value
     * @return string|null
     */
    public function getFailureReturnFormat()
    {
        return $this->FailureReturnFormat;
    }
    /**
     * Set FailureReturnFormat value
     * @param string $failureReturnFormat
     * @return \StructType\ListLibraryMailPacks
     */
    public function setFailureReturnFormat($failureReturnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($failureReturnFormat) && !is_string($failureReturnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($failureReturnFormat)), __LINE__);
        }
        $this->FailureReturnFormat = $failureReturnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListLibraryMailPacks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
