<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddUserSignupData StructType
 * @subpackage Structs
 */
class AddUserSignupData extends AbstractStructBase
{
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The SignUpHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SignUpHeader;
    /**
     * The SignUpValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SignUpValue;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for AddUserSignupData
     * @uses AddUserSignupData::setUsername()
     * @uses AddUserSignupData::setPassword()
     * @uses AddUserSignupData::setSignUpHeader()
     * @uses AddUserSignupData::setSignUpValue()
     * @uses AddUserSignupData::setReturnFormat()
     * @param string $username
     * @param string $password
     * @param string $signUpHeader
     * @param string $signUpValue
     * @param string $returnFormat
     */
    public function __construct($username = null, $password = null, $signUpHeader = null, $signUpValue = null, $returnFormat = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setSignUpHeader($signUpHeader)
            ->setSignUpValue($signUpValue)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\AddUserSignupData
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AddUserSignupData
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get SignUpHeader value
     * @return string|null
     */
    public function getSignUpHeader()
    {
        return $this->SignUpHeader;
    }
    /**
     * Set SignUpHeader value
     * @param string $signUpHeader
     * @return \StructType\AddUserSignupData
     */
    public function setSignUpHeader($signUpHeader = null)
    {
        // validation for constraint: string
        if (!is_null($signUpHeader) && !is_string($signUpHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signUpHeader)), __LINE__);
        }
        $this->SignUpHeader = $signUpHeader;
        return $this;
    }
    /**
     * Get SignUpValue value
     * @return string|null
     */
    public function getSignUpValue()
    {
        return $this->SignUpValue;
    }
    /**
     * Set SignUpValue value
     * @param string $signUpValue
     * @return \StructType\AddUserSignupData
     */
    public function setSignUpValue($signUpValue = null)
    {
        // validation for constraint: string
        if (!is_null($signUpValue) && !is_string($signUpValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signUpValue)), __LINE__);
        }
        $this->SignUpValue = $signUpValue;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\AddUserSignupData
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddUserSignupData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
