<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddUserOrganisationStructureLink StructType
 * @subpackage Structs
 */
class AddUserOrganisationStructureLink extends AbstractStructBase
{
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The LinkUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LinkUserName;
    /**
     * The OrganisationStructureLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrganisationStructureLevel;
    /**
     * The OrganisationStructureValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrganisationStructureValue;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for AddUserOrganisationStructureLink
     * @uses AddUserOrganisationStructureLink::setUsername()
     * @uses AddUserOrganisationStructureLink::setPassword()
     * @uses AddUserOrganisationStructureLink::setLinkUserName()
     * @uses AddUserOrganisationStructureLink::setOrganisationStructureLevel()
     * @uses AddUserOrganisationStructureLink::setOrganisationStructureValue()
     * @uses AddUserOrganisationStructureLink::setReturnFormat()
     * @param string $username
     * @param string $password
     * @param string $linkUserName
     * @param string $organisationStructureLevel
     * @param string $organisationStructureValue
     * @param string $returnFormat
     */
    public function __construct($username = null, $password = null, $linkUserName = null, $organisationStructureLevel = null, $organisationStructureValue = null, $returnFormat = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setLinkUserName($linkUserName)
            ->setOrganisationStructureLevel($organisationStructureLevel)
            ->setOrganisationStructureValue($organisationStructureValue)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\AddUserOrganisationStructureLink
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AddUserOrganisationStructureLink
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get LinkUserName value
     * @return string|null
     */
    public function getLinkUserName()
    {
        return $this->LinkUserName;
    }
    /**
     * Set LinkUserName value
     * @param string $linkUserName
     * @return \StructType\AddUserOrganisationStructureLink
     */
    public function setLinkUserName($linkUserName = null)
    {
        // validation for constraint: string
        if (!is_null($linkUserName) && !is_string($linkUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linkUserName)), __LINE__);
        }
        $this->LinkUserName = $linkUserName;
        return $this;
    }
    /**
     * Get OrganisationStructureLevel value
     * @return string|null
     */
    public function getOrganisationStructureLevel()
    {
        return $this->OrganisationStructureLevel;
    }
    /**
     * Set OrganisationStructureLevel value
     * @param string $organisationStructureLevel
     * @return \StructType\AddUserOrganisationStructureLink
     */
    public function setOrganisationStructureLevel($organisationStructureLevel = null)
    {
        // validation for constraint: string
        if (!is_null($organisationStructureLevel) && !is_string($organisationStructureLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisationStructureLevel)), __LINE__);
        }
        $this->OrganisationStructureLevel = $organisationStructureLevel;
        return $this;
    }
    /**
     * Get OrganisationStructureValue value
     * @return string|null
     */
    public function getOrganisationStructureValue()
    {
        return $this->OrganisationStructureValue;
    }
    /**
     * Set OrganisationStructureValue value
     * @param string $organisationStructureValue
     * @return \StructType\AddUserOrganisationStructureLink
     */
    public function setOrganisationStructureValue($organisationStructureValue = null)
    {
        // validation for constraint: string
        if (!is_null($organisationStructureValue) && !is_string($organisationStructureValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisationStructureValue)), __LINE__);
        }
        $this->OrganisationStructureValue = $organisationStructureValue;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\AddUserOrganisationStructureLink
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddUserOrganisationStructureLink
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
