<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddTemplateUseRule StructType
 * @subpackage Structs
 */
class AddTemplateUseRule extends AbstractStructBase
{
    /**
     * The MailingGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $MailingGUID;
    /**
     * The TemplateGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $TemplateGUID;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The AndGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AndGroup;
    /**
     * The AddressField
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressField;
    /**
     * The DataFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataFormat;
    /**
     * The FromEquation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromEquation;
    /**
     * The FromData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromData;
    /**
     * The ToEquation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToEquation;
    /**
     * The ToData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToData;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for AddTemplateUseRule
     * @uses AddTemplateUseRule::setMailingGUID()
     * @uses AddTemplateUseRule::setTemplateGUID()
     * @uses AddTemplateUseRule::setUsername()
     * @uses AddTemplateUseRule::setPassword()
     * @uses AddTemplateUseRule::setAndGroup()
     * @uses AddTemplateUseRule::setAddressField()
     * @uses AddTemplateUseRule::setDataFormat()
     * @uses AddTemplateUseRule::setFromEquation()
     * @uses AddTemplateUseRule::setFromData()
     * @uses AddTemplateUseRule::setToEquation()
     * @uses AddTemplateUseRule::setToData()
     * @uses AddTemplateUseRule::setReturnFormat()
     * @param string $mailingGUID
     * @param string $templateGUID
     * @param string $username
     * @param string $password
     * @param string $andGroup
     * @param string $addressField
     * @param string $dataFormat
     * @param string $fromEquation
     * @param string $fromData
     * @param string $toEquation
     * @param string $toData
     * @param string $returnFormat
     */
    public function __construct($mailingGUID = null, $templateGUID = null, $username = null, $password = null, $andGroup = null, $addressField = null, $dataFormat = null, $fromEquation = null, $fromData = null, $toEquation = null, $toData = null, $returnFormat = null)
    {
        $this
            ->setMailingGUID($mailingGUID)
            ->setTemplateGUID($templateGUID)
            ->setUsername($username)
            ->setPassword($password)
            ->setAndGroup($andGroup)
            ->setAddressField($addressField)
            ->setDataFormat($dataFormat)
            ->setFromEquation($fromEquation)
            ->setFromData($fromData)
            ->setToEquation($toEquation)
            ->setToData($toData)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get MailingGUID value
     * @return string
     */
    public function getMailingGUID()
    {
        return $this->MailingGUID;
    }
    /**
     * Set MailingGUID value
     * @param string $mailingGUID
     * @return \StructType\AddTemplateUseRule
     */
    public function setMailingGUID($mailingGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mailingGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($mailingGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mailingGUID) && !is_string($mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingGUID)), __LINE__);
        }
        $this->MailingGUID = $mailingGUID;
        return $this;
    }
    /**
     * Get TemplateGUID value
     * @return string
     */
    public function getTemplateGUID()
    {
        return $this->TemplateGUID;
    }
    /**
     * Set TemplateGUID value
     * @param string $templateGUID
     * @return \StructType\AddTemplateUseRule
     */
    public function setTemplateGUID($templateGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($templateGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $templateGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($templateGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($templateGUID) && !is_string($templateGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($templateGUID)), __LINE__);
        }
        $this->TemplateGUID = $templateGUID;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\AddTemplateUseRule
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AddTemplateUseRule
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get AndGroup value
     * @return string|null
     */
    public function getAndGroup()
    {
        return $this->AndGroup;
    }
    /**
     * Set AndGroup value
     * @param string $andGroup
     * @return \StructType\AddTemplateUseRule
     */
    public function setAndGroup($andGroup = null)
    {
        // validation for constraint: string
        if (!is_null($andGroup) && !is_string($andGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($andGroup)), __LINE__);
        }
        $this->AndGroup = $andGroup;
        return $this;
    }
    /**
     * Get AddressField value
     * @return string|null
     */
    public function getAddressField()
    {
        return $this->AddressField;
    }
    /**
     * Set AddressField value
     * @param string $addressField
     * @return \StructType\AddTemplateUseRule
     */
    public function setAddressField($addressField = null)
    {
        // validation for constraint: string
        if (!is_null($addressField) && !is_string($addressField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressField)), __LINE__);
        }
        $this->AddressField = $addressField;
        return $this;
    }
    /**
     * Get DataFormat value
     * @return string|null
     */
    public function getDataFormat()
    {
        return $this->DataFormat;
    }
    /**
     * Set DataFormat value
     * @param string $dataFormat
     * @return \StructType\AddTemplateUseRule
     */
    public function setDataFormat($dataFormat = null)
    {
        // validation for constraint: string
        if (!is_null($dataFormat) && !is_string($dataFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataFormat)), __LINE__);
        }
        $this->DataFormat = $dataFormat;
        return $this;
    }
    /**
     * Get FromEquation value
     * @return string|null
     */
    public function getFromEquation()
    {
        return $this->FromEquation;
    }
    /**
     * Set FromEquation value
     * @param string $fromEquation
     * @return \StructType\AddTemplateUseRule
     */
    public function setFromEquation($fromEquation = null)
    {
        // validation for constraint: string
        if (!is_null($fromEquation) && !is_string($fromEquation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromEquation)), __LINE__);
        }
        $this->FromEquation = $fromEquation;
        return $this;
    }
    /**
     * Get FromData value
     * @return string|null
     */
    public function getFromData()
    {
        return $this->FromData;
    }
    /**
     * Set FromData value
     * @param string $fromData
     * @return \StructType\AddTemplateUseRule
     */
    public function setFromData($fromData = null)
    {
        // validation for constraint: string
        if (!is_null($fromData) && !is_string($fromData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromData)), __LINE__);
        }
        $this->FromData = $fromData;
        return $this;
    }
    /**
     * Get ToEquation value
     * @return string|null
     */
    public function getToEquation()
    {
        return $this->ToEquation;
    }
    /**
     * Set ToEquation value
     * @param string $toEquation
     * @return \StructType\AddTemplateUseRule
     */
    public function setToEquation($toEquation = null)
    {
        // validation for constraint: string
        if (!is_null($toEquation) && !is_string($toEquation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toEquation)), __LINE__);
        }
        $this->ToEquation = $toEquation;
        return $this;
    }
    /**
     * Get ToData value
     * @return string|null
     */
    public function getToData()
    {
        return $this->ToData;
    }
    /**
     * Set ToData value
     * @param string $toData
     * @return \StructType\AddTemplateUseRule
     */
    public function setToData($toData = null)
    {
        // validation for constraint: string
        if (!is_null($toData) && !is_string($toData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toData)), __LINE__);
        }
        $this->ToData = $toData;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\AddTemplateUseRule
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddTemplateUseRule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
