<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddMailingListString StructType
 * @subpackage Structs
 */
class AddMailingListString extends AbstractStructBase
{
    /**
     * The MailingGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $MailingGUID;
    /**
     * The HasHeaders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasHeaders;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The MailingListData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailingListData;
    /**
     * The DataFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DataFormat;
    /**
     * The SheetName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SheetName;
    /**
     * The MappingDelimiter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MappingDelimiter;
    /**
     * The MappingFixedWidthChars
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MappingFixedWidthChars;
    /**
     * The MappingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MappingName;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for AddMailingListString
     * @uses AddMailingListString::setMailingGUID()
     * @uses AddMailingListString::setHasHeaders()
     * @uses AddMailingListString::setUsername()
     * @uses AddMailingListString::setPassword()
     * @uses AddMailingListString::setMailingListData()
     * @uses AddMailingListString::setDataFormat()
     * @uses AddMailingListString::setSheetName()
     * @uses AddMailingListString::setMappingDelimiter()
     * @uses AddMailingListString::setMappingFixedWidthChars()
     * @uses AddMailingListString::setMappingName()
     * @uses AddMailingListString::setReturnFormat()
     * @param string $mailingGUID
     * @param bool $hasHeaders
     * @param string $username
     * @param string $password
     * @param string $mailingListData
     * @param string $dataFormat
     * @param string $sheetName
     * @param string $mappingDelimiter
     * @param string $mappingFixedWidthChars
     * @param string $mappingName
     * @param string $returnFormat
     */
    public function __construct($mailingGUID = null, $hasHeaders = null, $username = null, $password = null, $mailingListData = null, $dataFormat = null, $sheetName = null, $mappingDelimiter = null, $mappingFixedWidthChars = null, $mappingName = null, $returnFormat = null)
    {
        $this
            ->setMailingGUID($mailingGUID)
            ->setHasHeaders($hasHeaders)
            ->setUsername($username)
            ->setPassword($password)
            ->setMailingListData($mailingListData)
            ->setDataFormat($dataFormat)
            ->setSheetName($sheetName)
            ->setMappingDelimiter($mappingDelimiter)
            ->setMappingFixedWidthChars($mappingFixedWidthChars)
            ->setMappingName($mappingName)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get MailingGUID value
     * @return string
     */
    public function getMailingGUID()
    {
        return $this->MailingGUID;
    }
    /**
     * Set MailingGUID value
     * @param string $mailingGUID
     * @return \StructType\AddMailingListString
     */
    public function setMailingGUID($mailingGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mailingGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($mailingGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mailingGUID) && !is_string($mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingGUID)), __LINE__);
        }
        $this->MailingGUID = $mailingGUID;
        return $this;
    }
    /**
     * Get HasHeaders value
     * @return bool
     */
    public function getHasHeaders()
    {
        return $this->HasHeaders;
    }
    /**
     * Set HasHeaders value
     * @param bool $hasHeaders
     * @return \StructType\AddMailingListString
     */
    public function setHasHeaders($hasHeaders = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasHeaders) && !is_bool($hasHeaders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasHeaders)), __LINE__);
        }
        $this->HasHeaders = $hasHeaders;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\AddMailingListString
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AddMailingListString
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get MailingListData value
     * @return string|null
     */
    public function getMailingListData()
    {
        return $this->MailingListData;
    }
    /**
     * Set MailingListData value
     * @param string $mailingListData
     * @return \StructType\AddMailingListString
     */
    public function setMailingListData($mailingListData = null)
    {
        // validation for constraint: string
        if (!is_null($mailingListData) && !is_string($mailingListData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingListData)), __LINE__);
        }
        $this->MailingListData = $mailingListData;
        return $this;
    }
    /**
     * Get DataFormat value
     * @return string|null
     */
    public function getDataFormat()
    {
        return $this->DataFormat;
    }
    /**
     * Set DataFormat value
     * @param string $dataFormat
     * @return \StructType\AddMailingListString
     */
    public function setDataFormat($dataFormat = null)
    {
        // validation for constraint: string
        if (!is_null($dataFormat) && !is_string($dataFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataFormat)), __LINE__);
        }
        $this->DataFormat = $dataFormat;
        return $this;
    }
    /**
     * Get SheetName value
     * @return string|null
     */
    public function getSheetName()
    {
        return $this->SheetName;
    }
    /**
     * Set SheetName value
     * @param string $sheetName
     * @return \StructType\AddMailingListString
     */
    public function setSheetName($sheetName = null)
    {
        // validation for constraint: string
        if (!is_null($sheetName) && !is_string($sheetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sheetName)), __LINE__);
        }
        $this->SheetName = $sheetName;
        return $this;
    }
    /**
     * Get MappingDelimiter value
     * @return string|null
     */
    public function getMappingDelimiter()
    {
        return $this->MappingDelimiter;
    }
    /**
     * Set MappingDelimiter value
     * @param string $mappingDelimiter
     * @return \StructType\AddMailingListString
     */
    public function setMappingDelimiter($mappingDelimiter = null)
    {
        // validation for constraint: string
        if (!is_null($mappingDelimiter) && !is_string($mappingDelimiter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mappingDelimiter)), __LINE__);
        }
        $this->MappingDelimiter = $mappingDelimiter;
        return $this;
    }
    /**
     * Get MappingFixedWidthChars value
     * @return string|null
     */
    public function getMappingFixedWidthChars()
    {
        return $this->MappingFixedWidthChars;
    }
    /**
     * Set MappingFixedWidthChars value
     * @param string $mappingFixedWidthChars
     * @return \StructType\AddMailingListString
     */
    public function setMappingFixedWidthChars($mappingFixedWidthChars = null)
    {
        // validation for constraint: string
        if (!is_null($mappingFixedWidthChars) && !is_string($mappingFixedWidthChars)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mappingFixedWidthChars)), __LINE__);
        }
        $this->MappingFixedWidthChars = $mappingFixedWidthChars;
        return $this;
    }
    /**
     * Get MappingName value
     * @return string|null
     */
    public function getMappingName()
    {
        return $this->MappingName;
    }
    /**
     * Set MappingName value
     * @param string $mappingName
     * @return \StructType\AddMailingListString
     */
    public function setMappingName($mappingName = null)
    {
        // validation for constraint: string
        if (!is_null($mappingName) && !is_string($mappingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mappingName)), __LINE__);
        }
        $this->MappingName = $mappingName;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\AddMailingListString
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddMailingListString
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
