<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddDesignerStoredImage StructType
 * @subpackage Structs
 */
class AddDesignerStoredImage extends AbstractStructBase
{
    /**
     * The MailingGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $MailingGUID;
    /**
     * The ImageRotation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ImageRotation;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The PartDisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartDisplayName;
    /**
     * The ImageName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageName;
    /**
     * The ImageFitOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImageFitOption;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for AddDesignerStoredImage
     * @uses AddDesignerStoredImage::setMailingGUID()
     * @uses AddDesignerStoredImage::setImageRotation()
     * @uses AddDesignerStoredImage::setUsername()
     * @uses AddDesignerStoredImage::setPassword()
     * @uses AddDesignerStoredImage::setPartDisplayName()
     * @uses AddDesignerStoredImage::setImageName()
     * @uses AddDesignerStoredImage::setImageFitOption()
     * @uses AddDesignerStoredImage::setReturnFormat()
     * @param string $mailingGUID
     * @param float $imageRotation
     * @param string $username
     * @param string $password
     * @param string $partDisplayName
     * @param string $imageName
     * @param string $imageFitOption
     * @param string $returnFormat
     */
    public function __construct($mailingGUID = null, $imageRotation = null, $username = null, $password = null, $partDisplayName = null, $imageName = null, $imageFitOption = null, $returnFormat = null)
    {
        $this
            ->setMailingGUID($mailingGUID)
            ->setImageRotation($imageRotation)
            ->setUsername($username)
            ->setPassword($password)
            ->setPartDisplayName($partDisplayName)
            ->setImageName($imageName)
            ->setImageFitOption($imageFitOption)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get MailingGUID value
     * @return string
     */
    public function getMailingGUID()
    {
        return $this->MailingGUID;
    }
    /**
     * Set MailingGUID value
     * @param string $mailingGUID
     * @return \StructType\AddDesignerStoredImage
     */
    public function setMailingGUID($mailingGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mailingGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($mailingGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mailingGUID) && !is_string($mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingGUID)), __LINE__);
        }
        $this->MailingGUID = $mailingGUID;
        return $this;
    }
    /**
     * Get ImageRotation value
     * @return float
     */
    public function getImageRotation()
    {
        return $this->ImageRotation;
    }
    /**
     * Set ImageRotation value
     * @param float $imageRotation
     * @return \StructType\AddDesignerStoredImage
     */
    public function setImageRotation($imageRotation = null)
    {
        $this->ImageRotation = $imageRotation;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\AddDesignerStoredImage
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AddDesignerStoredImage
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get PartDisplayName value
     * @return string|null
     */
    public function getPartDisplayName()
    {
        return $this->PartDisplayName;
    }
    /**
     * Set PartDisplayName value
     * @param string $partDisplayName
     * @return \StructType\AddDesignerStoredImage
     */
    public function setPartDisplayName($partDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($partDisplayName) && !is_string($partDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partDisplayName)), __LINE__);
        }
        $this->PartDisplayName = $partDisplayName;
        return $this;
    }
    /**
     * Get ImageName value
     * @return string|null
     */
    public function getImageName()
    {
        return $this->ImageName;
    }
    /**
     * Set ImageName value
     * @param string $imageName
     * @return \StructType\AddDesignerStoredImage
     */
    public function setImageName($imageName = null)
    {
        // validation for constraint: string
        if (!is_null($imageName) && !is_string($imageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageName)), __LINE__);
        }
        $this->ImageName = $imageName;
        return $this;
    }
    /**
     * Get ImageFitOption value
     * @return string|null
     */
    public function getImageFitOption()
    {
        return $this->ImageFitOption;
    }
    /**
     * Set ImageFitOption value
     * @param string $imageFitOption
     * @return \StructType\AddDesignerStoredImage
     */
    public function setImageFitOption($imageFitOption = null)
    {
        // validation for constraint: string
        if (!is_null($imageFitOption) && !is_string($imageFitOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageFitOption)), __LINE__);
        }
        $this->ImageFitOption = $imageFitOption;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\AddDesignerStoredImage
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddDesignerStoredImage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
