<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddAddress StructType
 * @subpackage Structs
 */
class AddAddress extends AbstractStructBase
{
    /**
     * The MailingGUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $MailingGUID;
    /**
     * The UseForProof
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UseForProof;
    /**
     * The StreamPages1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StreamPages1;
    /**
     * The StreamPages2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StreamPages2;
    /**
     * The StreamPages3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StreamPages3;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The Address3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address3;
    /**
     * The Address4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address4;
    /**
     * The Address5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address5;
    /**
     * The Address6
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address6;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Surname;
    /**
     * The Fullname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fullname;
    /**
     * The JobTitle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JobTitle;
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telephone;
    /**
     * The DirectLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DirectLine;
    /**
     * The Mobile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mobile;
    /**
     * The Facsimile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Facsimile;
    /**
     * The ExtraInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExtraInfo;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The CustomerAddressID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerAddressID;
    /**
     * The CustomerImportID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerImportID;
    /**
     * The Custom1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom1;
    /**
     * The Custom2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom2;
    /**
     * The Custom3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom3;
    /**
     * The Custom4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom4;
    /**
     * The Custom5
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom5;
    /**
     * The Custom6
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom6;
    /**
     * The Custom7
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom7;
    /**
     * The Custom8
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom8;
    /**
     * The Custom9
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom9;
    /**
     * The Custom10
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Custom10;
    /**
     * The ReturnFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReturnFormat;
    /**
     * Constructor method for AddAddress
     * @uses AddAddress::setMailingGUID()
     * @uses AddAddress::setUseForProof()
     * @uses AddAddress::setStreamPages1()
     * @uses AddAddress::setStreamPages2()
     * @uses AddAddress::setStreamPages3()
     * @uses AddAddress::setUsername()
     * @uses AddAddress::setPassword()
     * @uses AddAddress::setAddress1()
     * @uses AddAddress::setAddress2()
     * @uses AddAddress::setAddress3()
     * @uses AddAddress::setAddress4()
     * @uses AddAddress::setAddress5()
     * @uses AddAddress::setAddress6()
     * @uses AddAddress::setTitle()
     * @uses AddAddress::setFirstName()
     * @uses AddAddress::setSurname()
     * @uses AddAddress::setFullname()
     * @uses AddAddress::setJobTitle()
     * @uses AddAddress::setCompanyName()
     * @uses AddAddress::setEmail()
     * @uses AddAddress::setTelephone()
     * @uses AddAddress::setDirectLine()
     * @uses AddAddress::setMobile()
     * @uses AddAddress::setFacsimile()
     * @uses AddAddress::setExtraInfo()
     * @uses AddAddress::setNotes()
     * @uses AddAddress::setCustomerAddressID()
     * @uses AddAddress::setCustomerImportID()
     * @uses AddAddress::setCustom1()
     * @uses AddAddress::setCustom2()
     * @uses AddAddress::setCustom3()
     * @uses AddAddress::setCustom4()
     * @uses AddAddress::setCustom5()
     * @uses AddAddress::setCustom6()
     * @uses AddAddress::setCustom7()
     * @uses AddAddress::setCustom8()
     * @uses AddAddress::setCustom9()
     * @uses AddAddress::setCustom10()
     * @uses AddAddress::setReturnFormat()
     * @param string $mailingGUID
     * @param bool $useForProof
     * @param int $streamPages1
     * @param int $streamPages2
     * @param int $streamPages3
     * @param string $username
     * @param string $password
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $address4
     * @param string $address5
     * @param string $address6
     * @param string $title
     * @param string $firstName
     * @param string $surname
     * @param string $fullname
     * @param string $jobTitle
     * @param string $companyName
     * @param string $email
     * @param string $telephone
     * @param string $directLine
     * @param string $mobile
     * @param string $facsimile
     * @param string $extraInfo
     * @param string $notes
     * @param string $customerAddressID
     * @param string $customerImportID
     * @param string $custom1
     * @param string $custom2
     * @param string $custom3
     * @param string $custom4
     * @param string $custom5
     * @param string $custom6
     * @param string $custom7
     * @param string $custom8
     * @param string $custom9
     * @param string $custom10
     * @param string $returnFormat
     */
    public function __construct($mailingGUID = null, $useForProof = null, $streamPages1 = null, $streamPages2 = null, $streamPages3 = null, $username = null, $password = null, $address1 = null, $address2 = null, $address3 = null, $address4 = null, $address5 = null, $address6 = null, $title = null, $firstName = null, $surname = null, $fullname = null, $jobTitle = null, $companyName = null, $email = null, $telephone = null, $directLine = null, $mobile = null, $facsimile = null, $extraInfo = null, $notes = null, $customerAddressID = null, $customerImportID = null, $custom1 = null, $custom2 = null, $custom3 = null, $custom4 = null, $custom5 = null, $custom6 = null, $custom7 = null, $custom8 = null, $custom9 = null, $custom10 = null, $returnFormat = null)
    {
        $this
            ->setMailingGUID($mailingGUID)
            ->setUseForProof($useForProof)
            ->setStreamPages1($streamPages1)
            ->setStreamPages2($streamPages2)
            ->setStreamPages3($streamPages3)
            ->setUsername($username)
            ->setPassword($password)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setAddress4($address4)
            ->setAddress5($address5)
            ->setAddress6($address6)
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setSurname($surname)
            ->setFullname($fullname)
            ->setJobTitle($jobTitle)
            ->setCompanyName($companyName)
            ->setEmail($email)
            ->setTelephone($telephone)
            ->setDirectLine($directLine)
            ->setMobile($mobile)
            ->setFacsimile($facsimile)
            ->setExtraInfo($extraInfo)
            ->setNotes($notes)
            ->setCustomerAddressID($customerAddressID)
            ->setCustomerImportID($customerImportID)
            ->setCustom1($custom1)
            ->setCustom2($custom2)
            ->setCustom3($custom3)
            ->setCustom4($custom4)
            ->setCustom5($custom5)
            ->setCustom6($custom6)
            ->setCustom7($custom7)
            ->setCustom8($custom8)
            ->setCustom9($custom9)
            ->setCustom10($custom10)
            ->setReturnFormat($returnFormat);
    }
    /**
     * Get MailingGUID value
     * @return string
     */
    public function getMailingGUID()
    {
        return $this->MailingGUID;
    }
    /**
     * Set MailingGUID value
     * @param string $mailingGUID
     * @return \StructType\AddAddress
     */
    public function setMailingGUID($mailingGUID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mailingGUID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($mailingGUID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mailingGUID) && !is_string($mailingGUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailingGUID)), __LINE__);
        }
        $this->MailingGUID = $mailingGUID;
        return $this;
    }
    /**
     * Get UseForProof value
     * @return bool
     */
    public function getUseForProof()
    {
        return $this->UseForProof;
    }
    /**
     * Set UseForProof value
     * @param bool $useForProof
     * @return \StructType\AddAddress
     */
    public function setUseForProof($useForProof = null)
    {
        // validation for constraint: boolean
        if (!is_null($useForProof) && !is_bool($useForProof)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useForProof)), __LINE__);
        }
        $this->UseForProof = $useForProof;
        return $this;
    }
    /**
     * Get StreamPages1 value
     * @return int
     */
    public function getStreamPages1()
    {
        return $this->StreamPages1;
    }
    /**
     * Set StreamPages1 value
     * @param int $streamPages1
     * @return \StructType\AddAddress
     */
    public function setStreamPages1($streamPages1 = null)
    {
        // validation for constraint: int
        if (!is_null($streamPages1) && !is_numeric($streamPages1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($streamPages1)), __LINE__);
        }
        $this->StreamPages1 = $streamPages1;
        return $this;
    }
    /**
     * Get StreamPages2 value
     * @return int
     */
    public function getStreamPages2()
    {
        return $this->StreamPages2;
    }
    /**
     * Set StreamPages2 value
     * @param int $streamPages2
     * @return \StructType\AddAddress
     */
    public function setStreamPages2($streamPages2 = null)
    {
        // validation for constraint: int
        if (!is_null($streamPages2) && !is_numeric($streamPages2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($streamPages2)), __LINE__);
        }
        $this->StreamPages2 = $streamPages2;
        return $this;
    }
    /**
     * Get StreamPages3 value
     * @return int
     */
    public function getStreamPages3()
    {
        return $this->StreamPages3;
    }
    /**
     * Set StreamPages3 value
     * @param int $streamPages3
     * @return \StructType\AddAddress
     */
    public function setStreamPages3($streamPages3 = null)
    {
        // validation for constraint: int
        if (!is_null($streamPages3) && !is_numeric($streamPages3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($streamPages3)), __LINE__);
        }
        $this->StreamPages3 = $streamPages3;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\AddAddress
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AddAddress
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \StructType\AddAddress
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \StructType\AddAddress
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get Address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->Address3;
    }
    /**
     * Set Address3 value
     * @param string $address3
     * @return \StructType\AddAddress
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address3)), __LINE__);
        }
        $this->Address3 = $address3;
        return $this;
    }
    /**
     * Get Address4 value
     * @return string|null
     */
    public function getAddress4()
    {
        return $this->Address4;
    }
    /**
     * Set Address4 value
     * @param string $address4
     * @return \StructType\AddAddress
     */
    public function setAddress4($address4 = null)
    {
        // validation for constraint: string
        if (!is_null($address4) && !is_string($address4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address4)), __LINE__);
        }
        $this->Address4 = $address4;
        return $this;
    }
    /**
     * Get Address5 value
     * @return string|null
     */
    public function getAddress5()
    {
        return $this->Address5;
    }
    /**
     * Set Address5 value
     * @param string $address5
     * @return \StructType\AddAddress
     */
    public function setAddress5($address5 = null)
    {
        // validation for constraint: string
        if (!is_null($address5) && !is_string($address5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address5)), __LINE__);
        }
        $this->Address5 = $address5;
        return $this;
    }
    /**
     * Get Address6 value
     * @return string|null
     */
    public function getAddress6()
    {
        return $this->Address6;
    }
    /**
     * Set Address6 value
     * @param string $address6
     * @return \StructType\AddAddress
     */
    public function setAddress6($address6 = null)
    {
        // validation for constraint: string
        if (!is_null($address6) && !is_string($address6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address6)), __LINE__);
        }
        $this->Address6 = $address6;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\AddAddress
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\AddAddress
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\AddAddress
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get Fullname value
     * @return string|null
     */
    public function getFullname()
    {
        return $this->Fullname;
    }
    /**
     * Set Fullname value
     * @param string $fullname
     * @return \StructType\AddAddress
     */
    public function setFullname($fullname = null)
    {
        // validation for constraint: string
        if (!is_null($fullname) && !is_string($fullname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullname)), __LINE__);
        }
        $this->Fullname = $fullname;
        return $this;
    }
    /**
     * Get JobTitle value
     * @return string|null
     */
    public function getJobTitle()
    {
        return $this->JobTitle;
    }
    /**
     * Set JobTitle value
     * @param string $jobTitle
     * @return \StructType\AddAddress
     */
    public function setJobTitle($jobTitle = null)
    {
        // validation for constraint: string
        if (!is_null($jobTitle) && !is_string($jobTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($jobTitle)), __LINE__);
        }
        $this->JobTitle = $jobTitle;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \StructType\AddAddress
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\AddAddress
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \StructType\AddAddress
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get DirectLine value
     * @return string|null
     */
    public function getDirectLine()
    {
        return $this->DirectLine;
    }
    /**
     * Set DirectLine value
     * @param string $directLine
     * @return \StructType\AddAddress
     */
    public function setDirectLine($directLine = null)
    {
        // validation for constraint: string
        if (!is_null($directLine) && !is_string($directLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directLine)), __LINE__);
        }
        $this->DirectLine = $directLine;
        return $this;
    }
    /**
     * Get Mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->Mobile;
    }
    /**
     * Set Mobile value
     * @param string $mobile
     * @return \StructType\AddAddress
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobile)), __LINE__);
        }
        $this->Mobile = $mobile;
        return $this;
    }
    /**
     * Get Facsimile value
     * @return string|null
     */
    public function getFacsimile()
    {
        return $this->Facsimile;
    }
    /**
     * Set Facsimile value
     * @param string $facsimile
     * @return \StructType\AddAddress
     */
    public function setFacsimile($facsimile = null)
    {
        // validation for constraint: string
        if (!is_null($facsimile) && !is_string($facsimile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($facsimile)), __LINE__);
        }
        $this->Facsimile = $facsimile;
        return $this;
    }
    /**
     * Get ExtraInfo value
     * @return string|null
     */
    public function getExtraInfo()
    {
        return $this->ExtraInfo;
    }
    /**
     * Set ExtraInfo value
     * @param string $extraInfo
     * @return \StructType\AddAddress
     */
    public function setExtraInfo($extraInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extraInfo) && !is_string($extraInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extraInfo)), __LINE__);
        }
        $this->ExtraInfo = $extraInfo;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\AddAddress
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get CustomerAddressID value
     * @return string|null
     */
    public function getCustomerAddressID()
    {
        return $this->CustomerAddressID;
    }
    /**
     * Set CustomerAddressID value
     * @param string $customerAddressID
     * @return \StructType\AddAddress
     */
    public function setCustomerAddressID($customerAddressID = null)
    {
        // validation for constraint: string
        if (!is_null($customerAddressID) && !is_string($customerAddressID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerAddressID)), __LINE__);
        }
        $this->CustomerAddressID = $customerAddressID;
        return $this;
    }
    /**
     * Get CustomerImportID value
     * @return string|null
     */
    public function getCustomerImportID()
    {
        return $this->CustomerImportID;
    }
    /**
     * Set CustomerImportID value
     * @param string $customerImportID
     * @return \StructType\AddAddress
     */
    public function setCustomerImportID($customerImportID = null)
    {
        // validation for constraint: string
        if (!is_null($customerImportID) && !is_string($customerImportID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerImportID)), __LINE__);
        }
        $this->CustomerImportID = $customerImportID;
        return $this;
    }
    /**
     * Get Custom1 value
     * @return string|null
     */
    public function getCustom1()
    {
        return $this->Custom1;
    }
    /**
     * Set Custom1 value
     * @param string $custom1
     * @return \StructType\AddAddress
     */
    public function setCustom1($custom1 = null)
    {
        // validation for constraint: string
        if (!is_null($custom1) && !is_string($custom1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom1)), __LINE__);
        }
        $this->Custom1 = $custom1;
        return $this;
    }
    /**
     * Get Custom2 value
     * @return string|null
     */
    public function getCustom2()
    {
        return $this->Custom2;
    }
    /**
     * Set Custom2 value
     * @param string $custom2
     * @return \StructType\AddAddress
     */
    public function setCustom2($custom2 = null)
    {
        // validation for constraint: string
        if (!is_null($custom2) && !is_string($custom2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom2)), __LINE__);
        }
        $this->Custom2 = $custom2;
        return $this;
    }
    /**
     * Get Custom3 value
     * @return string|null
     */
    public function getCustom3()
    {
        return $this->Custom3;
    }
    /**
     * Set Custom3 value
     * @param string $custom3
     * @return \StructType\AddAddress
     */
    public function setCustom3($custom3 = null)
    {
        // validation for constraint: string
        if (!is_null($custom3) && !is_string($custom3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom3)), __LINE__);
        }
        $this->Custom3 = $custom3;
        return $this;
    }
    /**
     * Get Custom4 value
     * @return string|null
     */
    public function getCustom4()
    {
        return $this->Custom4;
    }
    /**
     * Set Custom4 value
     * @param string $custom4
     * @return \StructType\AddAddress
     */
    public function setCustom4($custom4 = null)
    {
        // validation for constraint: string
        if (!is_null($custom4) && !is_string($custom4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom4)), __LINE__);
        }
        $this->Custom4 = $custom4;
        return $this;
    }
    /**
     * Get Custom5 value
     * @return string|null
     */
    public function getCustom5()
    {
        return $this->Custom5;
    }
    /**
     * Set Custom5 value
     * @param string $custom5
     * @return \StructType\AddAddress
     */
    public function setCustom5($custom5 = null)
    {
        // validation for constraint: string
        if (!is_null($custom5) && !is_string($custom5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom5)), __LINE__);
        }
        $this->Custom5 = $custom5;
        return $this;
    }
    /**
     * Get Custom6 value
     * @return string|null
     */
    public function getCustom6()
    {
        return $this->Custom6;
    }
    /**
     * Set Custom6 value
     * @param string $custom6
     * @return \StructType\AddAddress
     */
    public function setCustom6($custom6 = null)
    {
        // validation for constraint: string
        if (!is_null($custom6) && !is_string($custom6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom6)), __LINE__);
        }
        $this->Custom6 = $custom6;
        return $this;
    }
    /**
     * Get Custom7 value
     * @return string|null
     */
    public function getCustom7()
    {
        return $this->Custom7;
    }
    /**
     * Set Custom7 value
     * @param string $custom7
     * @return \StructType\AddAddress
     */
    public function setCustom7($custom7 = null)
    {
        // validation for constraint: string
        if (!is_null($custom7) && !is_string($custom7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom7)), __LINE__);
        }
        $this->Custom7 = $custom7;
        return $this;
    }
    /**
     * Get Custom8 value
     * @return string|null
     */
    public function getCustom8()
    {
        return $this->Custom8;
    }
    /**
     * Set Custom8 value
     * @param string $custom8
     * @return \StructType\AddAddress
     */
    public function setCustom8($custom8 = null)
    {
        // validation for constraint: string
        if (!is_null($custom8) && !is_string($custom8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom8)), __LINE__);
        }
        $this->Custom8 = $custom8;
        return $this;
    }
    /**
     * Get Custom9 value
     * @return string|null
     */
    public function getCustom9()
    {
        return $this->Custom9;
    }
    /**
     * Set Custom9 value
     * @param string $custom9
     * @return \StructType\AddAddress
     */
    public function setCustom9($custom9 = null)
    {
        // validation for constraint: string
        if (!is_null($custom9) && !is_string($custom9)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom9)), __LINE__);
        }
        $this->Custom9 = $custom9;
        return $this;
    }
    /**
     * Get Custom10 value
     * @return string|null
     */
    public function getCustom10()
    {
        return $this->Custom10;
    }
    /**
     * Set Custom10 value
     * @param string $custom10
     * @return \StructType\AddAddress
     */
    public function setCustom10($custom10 = null)
    {
        // validation for constraint: string
        if (!is_null($custom10) && !is_string($custom10)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custom10)), __LINE__);
        }
        $this->Custom10 = $custom10;
        return $this;
    }
    /**
     * Get ReturnFormat value
     * @return string|null
     */
    public function getReturnFormat()
    {
        return $this->ReturnFormat;
    }
    /**
     * Set ReturnFormat value
     * @param string $returnFormat
     * @return \StructType\AddAddress
     */
    public function setReturnFormat($returnFormat = null)
    {
        // validation for constraint: string
        if (!is_null($returnFormat) && !is_string($returnFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnFormat)), __LINE__);
        }
        $this->ReturnFormat = $returnFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
