<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetMailPackVariableValue
     * Meta informations extracted from the WSDL
     * - documentation: Set a variable value for all templates containing the variable in the mail pack.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetMailPackVariableValue $parameters
     * @return \StructType\SetMailPackVariableValueResponse|bool
     */
    public function SetMailPackVariableValue(\StructType\SetMailPackVariableValue $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetMailPackVariableValue($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetTemplateVariableValue
     * Meta informations extracted from the WSDL
     * - documentation: Set template variable value.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetTemplateVariableValue $parameters
     * @return \StructType\SetTemplateVariableValueResponse|bool
     */
    public function SetTemplateVariableValue(\StructType\SetTemplateVariableValue $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetTemplateVariableValue($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetMailingListProofOption
     * Meta informations extracted from the WSDL
     * - documentation: Set the mailing list proof option.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetMailingListProofOption $parameters
     * @return \StructType\SetMailingListProofOptionResponse|bool
     */
    public function SetMailingListProofOption(\StructType\SetMailingListProofOption $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetMailingListProofOption($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetMailingListProofOptionResponse|\StructType\SetMailPackVariableValueResponse|\StructType\SetTemplateVariableValueResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
