<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Poll ServiceType
 * @subpackage Services
 */
class Poll extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PollMailingListAddressCounts
     * Meta informations extracted from the WSDL
     * - documentation: Get the address counts for a mailing list. The address counts returned can be passed to GetPriceEstimate to calculate an estimated price.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PollMailingListAddressCounts $parameters
     * @return \StructType\PollMailingListAddressCountsResponse|bool
     */
    public function PollMailingListAddressCounts(\StructType\PollMailingListAddressCounts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PollMailingListAddressCounts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PollMailingListAddressCountsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
