<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Extended ServiceType
 * @subpackage Services
 */
class Extended extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ExtendedCall
     * Meta informations extracted from the WSDL
     * - documentation: Call an extended method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExtendedCall $parameters
     * @return \StructType\ExtendedCallResponse|bool
     */
    public function ExtendedCall(\StructType\ExtendedCall $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExtendedCall($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExtendedCallDefinition
     * Meta informations extracted from the WSDL
     * - documentation: Get the definition for an extended method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExtendedCallDefinition $parameters
     * @return \StructType\ExtendedCallDefinitionResponse|bool
     */
    public function ExtendedCallDefinition(\StructType\ExtendedCallDefinition $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExtendedCallDefinition($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ExtendedCallDefinitionResponse|\StructType\ExtendedCallResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
