<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelMailing
     * Meta informations extracted from the WSDL
     * - documentation: Cancel a mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelMailing $parameters
     * @return \StructType\CancelMailingResponse|bool
     */
    public function CancelMailing(\StructType\CancelMailing $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CancelMailing($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelMailingApproval
     * Meta informations extracted from the WSDL
     * - documentation: User approve the mailing, optionally auto submitting the mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelMailingApproval $parameters
     * @return \StructType\CancelMailingApprovalResponse|bool
     */
    public function CancelMailingApproval(\StructType\CancelMailingApproval $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CancelMailingApproval($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CancelMailingApprovalResponse|\StructType\CancelMailingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
