<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddMailingFilter
     * Meta informations extracted from the WSDL
     * - documentation: Add a mailing filter. For use by corporate accounts only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMailingFilter $parameters
     * @return \StructType\AddMailingFilterResponse|bool
     */
    public function AddMailingFilter(\StructType\AddMailingFilter $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMailingFilter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDeliveryAddress
     * Meta informations extracted from the WSDL
     * - documentation: Add a delivery address. For use with courier delivery mailings only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDeliveryAddress $parameters
     * @return \StructType\AddDeliveryAddressResponse|bool
     */
    public function AddDeliveryAddress(\StructType\AddDeliveryAddress $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddDeliveryAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTemplateFile
     * Meta informations extracted from the WSDL
     * - documentation: Add a template file to a mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTemplateFile $parameters
     * @return \StructType\AddTemplateFileResponse|bool
     */
    public function AddTemplateFile(\StructType\AddTemplateFile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddTemplateFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTemplateBackgroundFile
     * Meta informations extracted from the WSDL
     * - documentation: Add background file to a template.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTemplateBackgroundFile $parameters
     * @return \StructType\AddTemplateBackgroundFileResponse|bool
     */
    public function AddTemplateBackgroundFile(\StructType\AddTemplateBackgroundFile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddTemplateBackgroundFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTemplateFromLibrary
     * Meta informations extracted from the WSDL
     * - documentation: Add a template from the library.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTemplateFromLibrary $parameters
     * @return \StructType\AddTemplateFromLibraryResponse|bool
     */
    public function AddTemplateFromLibrary(\StructType\AddTemplateFromLibrary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddTemplateFromLibrary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTemplateFromOrder
     * Meta informations extracted from the WSDL
     * - documentation: Add a template from a previous order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTemplateFromOrder $parameters
     * @return \StructType\AddTemplateFromOrderResponse|bool
     */
    public function AddTemplateFromOrder(\StructType\AddTemplateFromOrder $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddTemplateFromOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMailPackFromLibrary
     * Meta informations extracted from the WSDL
     * - documentation: Add mail pack from library.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMailPackFromLibrary $parameters
     * @return \StructType\AddMailPackFromLibraryResponse|bool
     */
    public function AddMailPackFromLibrary(\StructType\AddMailPackFromLibrary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMailPackFromLibrary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMailPackFromOrder
     * Meta informations extracted from the WSDL
     * - documentation: Add a mail pack from a previous order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMailPackFromOrder $parameters
     * @return \StructType\AddMailPackFromOrderResponse|bool
     */
    public function AddMailPackFromOrder(\StructType\AddMailPackFromOrder $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMailPackFromOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDesignerTemplate
     * Meta informations extracted from the WSDL
     * - documentation: Add a designer template.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDesignerTemplate $parameters
     * @return \StructType\AddDesignerTemplateResponse|bool
     */
    public function AddDesignerTemplate(\StructType\AddDesignerTemplate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddDesignerTemplate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDesignerImage
     * Meta informations extracted from the WSDL
     * - documentation: Add a designer image.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDesignerImage $parameters
     * @return \StructType\AddDesignerImageResponse|bool
     */
    public function AddDesignerImage(\StructType\AddDesignerImage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddDesignerImage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDesignerStoredImage
     * Meta informations extracted from the WSDL
     * - documentation: Add designer stored image.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDesignerStoredImage $parameters
     * @return \StructType\AddDesignerStoredImageResponse|bool
     */
    public function AddDesignerStoredImage(\StructType\AddDesignerStoredImage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddDesignerStoredImage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddDesignerText
     * Meta informations extracted from the WSDL
     * - documentation: Add designer text.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddDesignerText $parameters
     * @return \StructType\AddDesignerTextResponse|bool
     */
    public function AddDesignerText(\StructType\AddDesignerText $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddDesignerText($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTemplateUseRule
     * Meta informations extracted from the WSDL
     * - documentation: Add a template use rule.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTemplateUseRule $parameters
     * @return \StructType\AddTemplateUseRuleResponse|bool
     */
    public function AddTemplateUseRule(\StructType\AddTemplateUseRule $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddTemplateUseRule($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTemplateBackgroundRule
     * Meta informations extracted from the WSDL
     * - documentation: Add a template background rule.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTemplateBackgroundRule $parameters
     * @return \StructType\AddTemplateBackgroundRuleResponse|bool
     */
    public function AddTemplateBackgroundRule(\StructType\AddTemplateBackgroundRule $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddTemplateBackgroundRule($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMailingListFile
     * Meta informations extracted from the WSDL
     * - documentation: Add a mailing list file.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMailingListFile $parameters
     * @return \StructType\AddMailingListFileResponse|bool
     */
    public function AddMailingListFile(\StructType\AddMailingListFile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMailingListFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMailingListString
     * Meta informations extracted from the WSDL
     * - documentation: Add a mailing list string.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMailingListString $parameters
     * @return \StructType\AddMailingListStringResponse|bool
     */
    public function AddMailingListString(\StructType\AddMailingListString $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMailingListString($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMailingListFromLibrary
     * Meta informations extracted from the WSDL
     * - documentation: Add a mailing list from the library.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMailingListFromLibrary $parameters
     * @return \StructType\AddMailingListFromLibraryResponse|bool
     */
    public function AddMailingListFromLibrary(\StructType\AddMailingListFromLibrary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMailingListFromLibrary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMailingListFromOrder
     * Meta informations extracted from the WSDL
     * - documentation: Add a mailing list from a previous order.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMailingListFromOrder $parameters
     * @return \StructType\AddMailingListFromOrderResponse|bool
     */
    public function AddMailingListFromOrder(\StructType\AddMailingListFromOrder $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMailingListFromOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAddress
     * Meta informations extracted from the WSDL
     * - documentation: Add an address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAddress $parameters
     * @return \StructType\AddAddressResponse|bool
     */
    public function AddAddress(\StructType\AddAddress $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSelf
     * Meta informations extracted from the WSDL
     * - documentation: Add self to the mailing.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddSelf $parameters
     * @return \StructType\AddSelfResponse|bool
     */
    public function AddSelf(\StructType\AddSelf $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddSelf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUser
     * Meta informations extracted from the WSDL
     * - documentation: Add a user to your account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUser $parameters
     * @return \StructType\AddUserResponse|bool
     */
    public function AddUser(\StructType\AddUser $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddUser($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserOrganisationStructureLink
     * Meta informations extracted from the WSDL
     * - documentation: Link a user to an organisational structure. For use by corporate accounts only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUserOrganisationStructureLink $parameters
     * @return \StructType\AddUserOrganisationStructureLinkResponse|bool
     */
    public function AddUserOrganisationStructureLink(\StructType\AddUserOrganisationStructureLink $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddUserOrganisationStructureLink($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddUserSignupData
     * Meta informations extracted from the WSDL
     * - documentation: Add custom signup data for the user. For use by corporate accounts only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddUserSignupData $parameters
     * @return \StructType\AddUserSignupDataResponse|bool
     */
    public function AddUserSignupData(\StructType\AddUserSignupData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddUserSignupData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMailingListFileToLibrary
     * Meta informations extracted from the WSDL
     * - documentation: Save a mailing list file to a library mailing list, creating the mailing list if it does not already exists. Returns MailingListGUID that can be passed to PollMailingListAddressCounts to get the address counts.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMailingListFileToLibrary $parameters
     * @return \StructType\AddMailingListFileToLibraryResponse|bool
     */
    public function AddMailingListFileToLibrary(\StructType\AddMailingListFileToLibrary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMailingListFileToLibrary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMailingListStringToLibrary
     * Meta informations extracted from the WSDL
     * - documentation: Save a mailing list from a string to a library mailing list, creating the mailing list if it does not already exists. Returns MailingListGUID that can be passed to PollMailingListAddressCounts to get the address counts.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMailingListStringToLibrary $parameters
     * @return \StructType\AddMailingListStringToLibraryResponse|bool
     */
    public function AddMailingListStringToLibrary(\StructType\AddMailingListStringToLibrary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMailingListStringToLibrary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTemplateFileToLibrary
     * Meta informations extracted from the WSDL
     * - documentation: Add a template file to the library. This can be used on an order by calling AddTemplateFromLibrary.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTemplateFileToLibrary $parameters
     * @return \StructType\AddTemplateFileToLibraryResponse|bool
     */
    public function AddTemplateFileToLibrary(\StructType\AddTemplateFileToLibrary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddTemplateFileToLibrary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddBackgroundFileToLibrary
     * Meta informations extracted from the WSDL
     * - documentation: Add a background file to the library. Overwrites the existing background if it already exists.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddBackgroundFileToLibrary $parameters
     * @return \StructType\AddBackgroundFileToLibraryResponse|bool
     */
    public function AddBackgroundFileToLibrary(\StructType\AddBackgroundFileToLibrary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddBackgroundFileToLibrary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMailPackToLibrary
     * Meta informations extracted from the WSDL
     * - documentation: Add a mail pack to the library, will return the existing mail pack if already exists.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMailPackToLibrary $parameters
     * @return \StructType\AddMailPackToLibraryResponse|bool
     */
    public function AddMailPackToLibrary(\StructType\AddMailPackToLibrary $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMailPackToLibrary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddTemplateToLibraryMailPack
     * Meta informations extracted from the WSDL
     * - documentation: Add a template to a library mail pack.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddTemplateToLibraryMailPack $parameters
     * @return \StructType\AddTemplateToLibraryMailPackResponse|bool
     */
    public function AddTemplateToLibraryMailPack(\StructType\AddTemplateToLibraryMailPack $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddTemplateToLibraryMailPack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * AddMailingListStringForAddressCount
     * Meta informations extracted from the WSDL
     * - documentation: Save a temporary mailing list from a string to obtaining address counts. Returns MailingListGUID that can be passed to PollMailingListAddressCounts to get the address counts.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMailingListStringForAddressCount $parameters
     * @return \StructType\AddMailingListStringForAddressCountResponse|bool
     */
    public function AddMailingListStringForAddressCount(\StructType\AddMailingListStringForAddressCount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMailingListStringForAddressCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddMailingListFileForAddressCount
     * Meta informations extracted from the WSDL
     * - documentation: Save a temporary mailing list file to obtaining address counts. Returns MailingListGUID that can be passed to PollMailingListAddressCounts to get the address counts.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddMailingListFileForAddressCount $parameters
     * @return \StructType\AddMailingListFileForAddressCountResponse|bool
     */
    public function AddMailingListFileForAddressCount(\StructType\AddMailingListFileForAddressCount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddMailingListFileForAddressCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddAddressResponse|\StructType\AddBackgroundFileToLibraryResponse|\StructType\AddDeliveryAddressResponse|\StructType\AddDesignerImageResponse|\StructType\AddDesignerStoredImageResponse|\StructType\AddDesignerTemplateResponse|\StructType\AddDesignerTextResponse|\StructType\AddMailingFilterResponse|\StructType\AddMailingListFileForAddressCountResponse|\StructType\AddMailingListFileResponse|\StructType\AddMailingListFileToLibraryResponse|\StructType\AddMailingListFromLibraryResponse|\StructType\AddMailingListFromOrderResponse|\StructType\AddMailingListStringForAddressCountResponse|\StructType\AddMailingListStringResponse|\StructType\AddMailingListStringToLibraryResponse|\StructType\AddMailPackFromLibraryResponse|\StructType\AddMailPackFromOrderResponse|\StructType\AddMailPackToLibraryResponse|\StructType\AddSelfResponse|\StructType\AddTemplateBackgroundFileResponse|\StructType\AddTemplateBackgroundRuleResponse|\StructType\AddTemplateFileResponse|\StructType\AddTemplateFileToLibraryResponse|\StructType\AddTemplateFromLibraryResponse|\StructType\AddTemplateFromOrderResponse|\StructType\AddTemplateToLibraryMailPackResponse|\StructType\AddTemplateUseRuleResponse|\StructType\AddUserOrganisationStructureLinkResponse|\StructType\AddUserResponse|\StructType\AddUserSignupDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
