<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Moneytransfer ServiceType
 * @subpackage Services
 */
class Moneytransfer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named money_transfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $amount
     * @param string $currency
     * @param string $giver_country
     * @param string $giver_email
     * @param string $giver_first_name
     * @param string $giver_last_name
     * @param string $giver_tel
     * @param string $hash
     * @param string $iDReseller
     * @param string $iDTransaction
     * @param string $iDUser
     * @param string $pincode
     * @param string $receiver_country
     * @param string $receiver_email
     * @param string $receiver_first_name
     * @param string $receiver_last_name
     * @param string $receiver_tel
     * @return array|bool
     */
    public function money_transfer($amount, $currency, $giver_country, $giver_email, $giver_first_name, $giver_last_name, $giver_tel, $hash, $iDReseller, $iDTransaction, $iDUser, $pincode, $receiver_country, $receiver_email, $receiver_first_name, $receiver_last_name, $receiver_tel)
    {
        try {
            $this->setResult($this->getSoapClient()->money_transfer($amount, $currency, $giver_country, $giver_email, $giver_first_name, $giver_last_name, $giver_tel, $hash, $iDReseller, $iDTransaction, $iDUser, $pincode, $receiver_country, $receiver_email, $receiver_first_name, $receiver_last_name, $receiver_tel));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
