<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Billpayment ServiceType
 * @subpackage Services
 */
class Billpayment extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named bill_payment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $amount
     * @param string $currency
     * @param string $hash
     * @param string $iDReseller
     * @param string $iDTransaction
     * @param string $iDUser
     * @param string $operator
     * @return array|bool
     */
    public function bill_payment($amount, $currency, $hash, $iDReseller, $iDTransaction, $iDUser, $operator)
    {
        try {
            $this->setResult($this->getSoapClient()->bill_payment($amount, $currency, $hash, $iDReseller, $iDTransaction, $iDUser, $operator));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
