<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Transaction ServiceType
 * @subpackage Services
 */
class Transaction extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named transactionFinalAmount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionFinalAmount($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionFinalAmount($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionCreditCardWithout3D
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionCreditCardWithout3D($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionCreditCardWithout3D($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return string|bool
     */
    public function transactionGateway($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionGateway($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionGatewayCallback
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionGatewayCallback($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionGatewayCallback($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionGatewayCheckCallback
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $creditCardBin
     * @param string $creditCardCountry
     * @param string $creditCardExpiryDate
     * @param string $creditCardLast4
     * @param string $creditCardScheme
     * @param string $hash
     * @param string $informations
     * @param string $transactionId
     * @return boolean|bool
     */
    public function transactionGatewayCheckCallback($creditCardBin, $creditCardCountry, $creditCardExpiryDate, $creditCardLast4, $creditCardScheme, $hash, $informations, $transactionId)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionGatewayCheckCallback($creditCardBin, $creditCardCountry, $creditCardExpiryDate, $creditCardLast4, $creditCardScheme, $hash, $informations, $transactionId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionNeosurfCreditEmail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionNeosurfCreditEmail($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionNeosurfCreditEmail($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionNeosurfCreditPay
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionNeosurfCreditPay($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionNeosurfCreditPay($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionNeosurfCreditUserId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionNeosurfCreditUserId($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionNeosurfCreditUserId($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionNeosurfPin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionNeosurfPin($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionNeosurfPin($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionNeosurfSerialNb
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionNeosurfSerialNb($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionNeosurfSerialNb($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionNeosurfLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionNeosurfLogin($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionNeosurfLogin($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionNeosurfUserId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionNeosurfUserId($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionNeosurfUserId($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionNeosurfReverse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionNeosurfReverse($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionNeosurfReverse($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionQrcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionQrcode($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionQrcode($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionCheckSignature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return string|bool
     */
    public function transactionCheckSignature($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionCheckSignature($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionInit2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionInit2($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionInit2($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionInit3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionInit3($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionInit3($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionPayInStoreInit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionPayInStoreInit($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionPayInStoreInit($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionPayInStoreFinalize
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return string|bool
     */
    public function transactionPayInStoreFinalize($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionPayInStoreFinalize($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionCreditcardFinalize
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return string|bool
     */
    public function transactionCreditcardFinalize($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionCreditcardFinalize($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionCreditcardCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return string|bool
     */
    public function transactionCreditcardCheck($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionCreditcardCheck($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionKycCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return string|bool
     */
    public function transactionKycCheck($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionKycCheck($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionIpAndCountry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionIpAndCountry($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionIpAndCountry($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionIpControl
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionIpControl($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionIpControl($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionAtmCodesPatch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionAtmCodesPatch($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionAtmCodesPatch($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionClose
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionClose($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionClose($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionCreditCardWith3D
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return string|bool
     */
    public function transactionCreditCardWith3D($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionCreditCardWith3D($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionGetDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionGetDetails($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionGetDetails($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named transactionNeosurfPinDeposit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function transactionNeosurfPinDeposit($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->transactionNeosurfPinDeposit($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array|boolean|string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
