<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Neopaycheckcode ServiceType
 * @subpackage Services
 */
class Neopaycheckcode extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named neopay_check_code
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $hash
     * @param string $iDReseller
     * @param string $iDUser
     * @param string $pincode
     * @return array|bool
     */
    public function neopay_check_code($hash, $iDReseller, $iDUser, $pincode)
    {
        try {
            $this->setResult($this->getSoapClient()->neopay_check_code($hash, $iDReseller, $iDUser, $pincode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
