<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Getecheck ServiceType
 * @subpackage Services
 */
class Getecheck extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named get_echeck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $amount
     * @param string $currency
     * @param string $hash
     * @param string $iDProduct
     * @param string $iDReseller
     * @param string $iDTransaction
     * @param string $iDUser
     * @return array|bool
     */
    public function get_echeck($amount, $currency, $hash, $iDProduct, $iDReseller, $iDTransaction, $iDUser)
    {
        try {
            $this->setResult($this->getSoapClient()->get_echeck($amount, $currency, $hash, $iDProduct, $iDReseller, $iDTransaction, $iDUser));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
