<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rproduct StructType
 * @subpackage Structs
 */
class Rproduct extends AbstractStructBase
{
    /**
     * The currency
     * @var string
     */
    public $currency;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The dt_version
     * @var string
     */
    public $dt_version;
    /**
     * The ean13
     * @var string
     */
    public $ean13;
    /**
     * The IDProduct
     * @var int
     */
    public $IDProduct;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The price
     * @var int
     */
    public $price;
    /**
     * The provider
     * @var string
     */
    public $provider;
    /**
     * The reseller_commission
     * @var int
     */
    public $reseller_commission;
    /**
     * The short_name
     * @var string
     */
    public $short_name;
    /**
     * The tva
     * @var int
     */
    public $tva;
    /**
     * The neomiles
     * @var int
     */
    public $neomiles;
    /**
     * Constructor method for rproduct
     * @uses Rproduct::setCurrency()
     * @uses Rproduct::setDescription()
     * @uses Rproduct::setDt_version()
     * @uses Rproduct::setEan13()
     * @uses Rproduct::setIDProduct()
     * @uses Rproduct::setName()
     * @uses Rproduct::setPrice()
     * @uses Rproduct::setProvider()
     * @uses Rproduct::setReseller_commission()
     * @uses Rproduct::setShort_name()
     * @uses Rproduct::setTva()
     * @uses Rproduct::setNeomiles()
     * @param string $currency
     * @param string $description
     * @param string $dt_version
     * @param string $ean13
     * @param int $iDProduct
     * @param string $name
     * @param int $price
     * @param string $provider
     * @param int $reseller_commission
     * @param string $short_name
     * @param int $tva
     * @param int $neomiles
     */
    public function __construct($currency = null, $description = null, $dt_version = null, $ean13 = null, $iDProduct = null, $name = null, $price = null, $provider = null, $reseller_commission = null, $short_name = null, $tva = null, $neomiles = null)
    {
        $this
            ->setCurrency($currency)
            ->setDescription($description)
            ->setDt_version($dt_version)
            ->setEan13($ean13)
            ->setIDProduct($iDProduct)
            ->setName($name)
            ->setPrice($price)
            ->setProvider($provider)
            ->setReseller_commission($reseller_commission)
            ->setShort_name($short_name)
            ->setTva($tva)
            ->setNeomiles($neomiles);
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\Rproduct
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Rproduct
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get dt_version value
     * @return string|null
     */
    public function getDt_version()
    {
        return $this->dt_version;
    }
    /**
     * Set dt_version value
     * @param string $dt_version
     * @return \StructType\Rproduct
     */
    public function setDt_version($dt_version = null)
    {
        // validation for constraint: string
        if (!is_null($dt_version) && !is_string($dt_version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dt_version, true), gettype($dt_version)), __LINE__);
        }
        $this->dt_version = $dt_version;
        return $this;
    }
    /**
     * Get ean13 value
     * @return string|null
     */
    public function getEan13()
    {
        return $this->ean13;
    }
    /**
     * Set ean13 value
     * @param string $ean13
     * @return \StructType\Rproduct
     */
    public function setEan13($ean13 = null)
    {
        // validation for constraint: string
        if (!is_null($ean13) && !is_string($ean13)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ean13, true), gettype($ean13)), __LINE__);
        }
        $this->ean13 = $ean13;
        return $this;
    }
    /**
     * Get IDProduct value
     * @return int|null
     */
    public function getIDProduct()
    {
        return $this->IDProduct;
    }
    /**
     * Set IDProduct value
     * @param int $iDProduct
     * @return \StructType\Rproduct
     */
    public function setIDProduct($iDProduct = null)
    {
        // validation for constraint: int
        if (!is_null($iDProduct) && !(is_int($iDProduct) || ctype_digit($iDProduct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDProduct, true), gettype($iDProduct)), __LINE__);
        }
        $this->IDProduct = $iDProduct;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Rproduct
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get price value
     * @return int|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param int $price
     * @return \StructType\Rproduct
     */
    public function setPrice($price = null)
    {
        // validation for constraint: int
        if (!is_null($price) && !(is_int($price) || ctype_digit($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get provider value
     * @return string|null
     */
    public function getProvider()
    {
        return $this->provider;
    }
    /**
     * Set provider value
     * @param string $provider
     * @return \StructType\Rproduct
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider, true), gettype($provider)), __LINE__);
        }
        $this->provider = $provider;
        return $this;
    }
    /**
     * Get reseller_commission value
     * @return int|null
     */
    public function getReseller_commission()
    {
        return $this->reseller_commission;
    }
    /**
     * Set reseller_commission value
     * @param int $reseller_commission
     * @return \StructType\Rproduct
     */
    public function setReseller_commission($reseller_commission = null)
    {
        // validation for constraint: int
        if (!is_null($reseller_commission) && !(is_int($reseller_commission) || ctype_digit($reseller_commission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reseller_commission, true), gettype($reseller_commission)), __LINE__);
        }
        $this->reseller_commission = $reseller_commission;
        return $this;
    }
    /**
     * Get short_name value
     * @return string|null
     */
    public function getShort_name()
    {
        return $this->short_name;
    }
    /**
     * Set short_name value
     * @param string $short_name
     * @return \StructType\Rproduct
     */
    public function setShort_name($short_name = null)
    {
        // validation for constraint: string
        if (!is_null($short_name) && !is_string($short_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($short_name, true), gettype($short_name)), __LINE__);
        }
        $this->short_name = $short_name;
        return $this;
    }
    /**
     * Get tva value
     * @return int|null
     */
    public function getTva()
    {
        return $this->tva;
    }
    /**
     * Set tva value
     * @param int $tva
     * @return \StructType\Rproduct
     */
    public function setTva($tva = null)
    {
        // validation for constraint: int
        if (!is_null($tva) && !(is_int($tva) || ctype_digit($tva))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tva, true), gettype($tva)), __LINE__);
        }
        $this->tva = $tva;
        return $this;
    }
    /**
     * Get neomiles value
     * @return int|null
     */
    public function getNeomiles()
    {
        return $this->neomiles;
    }
    /**
     * Set neomiles value
     * @param int $neomiles
     * @return \StructType\Rproduct
     */
    public function setNeomiles($neomiles = null)
    {
        // validation for constraint: int
        if (!is_null($neomiles) && !(is_int($neomiles) || ctype_digit($neomiles))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($neomiles, true), gettype($neomiles)), __LINE__);
        }
        $this->neomiles = $neomiles;
        return $this;
    }
}
