<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Creditcard ServiceType
 * @subpackage Services
 */
class Creditcard extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named credit_card
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $amount
     * @param string $currency
     * @param string $hash
     * @param string $iDReseller
     * @param string $iDTransaction
     * @param string $iDUser
     * @param string $serial_nb
     * @return array|bool
     */
    public function credit_card($amount, $currency, $hash, $iDReseller, $iDTransaction, $iDUser, $serial_nb)
    {
        try {
            $this->setResult($this->getSoapClient()->credit_card($amount, $currency, $hash, $iDReseller, $iDTransaction, $iDUser, $serial_nb));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
