<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Makepayment ServiceType
 * @subpackage Services
 */
class Makepayment extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named make_payment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $amount
     * @param string $currency
     * @param string $hash
     * @param string $iDMerchant
     * @param string $iDService
     * @param string $iDTicket
     * @param string $iDTransaction
     * @return array|bool
     */
    public function make_payment($amount, $currency, $hash, $iDMerchant, $iDService, $iDTicket, $iDTransaction)
    {
        try {
            $this->setResult($this->getSoapClient()->make_payment($amount, $currency, $hash, $iDMerchant, $iDService, $iDTicket, $iDTransaction));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
