<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pincode ServiceType
 * @subpackage Services
 */
class Pincode extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named pincodeLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function pincodeLogin($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->pincodeLogin($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
