<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Neopayburncode ServiceType
 * @subpackage Services
 */
class Neopayburncode extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named neopay_burn_code
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $hash
     * @param string $iDReseller
     * @param string $iDTransaction
     * @param string $iDUser
     * @param string $pincode
     * @return array|bool
     */
    public function neopay_burn_code($hash, $iDReseller, $iDTransaction, $iDUser, $pincode)
    {
        try {
            $this->setResult($this->getSoapClient()->neopay_burn_code($hash, $iDReseller, $iDTransaction, $iDUser, $pincode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
