<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Neocashcredit ServiceType
 * @subpackage Services
 */
class Neocashcredit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named neocash_credit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $amount
     * @param string $currency
     * @param string $hash
     * @param string $iDReseller
     * @param string $iDTransaction
     * @param string $iDUser
     * @param string $serial_nb
     * @return array|bool
     */
    public function neocash_credit($amount, $currency, $hash, $iDReseller, $iDTransaction, $iDUser, $serial_nb)
    {
        try {
            $this->setResult($this->getSoapClient()->neocash_credit($amount, $currency, $hash, $iDReseller, $iDTransaction, $iDUser, $serial_nb));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
