<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.neosurf.info/soap/index.php?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.neosurf.info/soap/index.php?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Billpayment ServiceType
 */
$billpayment = new \ServiceType\Billpayment($options);
/**
 * Sample call for bill_payment operation/method
 */
if ($billpayment->bill_payment($amount, $currency, $hash, $IDReseller, $IDTransaction, $IDUser, $operator) !== false) {
    print_r($billpayment->getResult());
} else {
    print_r($billpayment->getLastError());
}
/**
 * Samples for Cancelpayment ServiceType
 */
$cancelpayment = new \ServiceType\Cancelpayment($options);
/**
 * Sample call for cancel_payment operation/method
 */
if ($cancelpayment->cancel_payment($hash, $IDMerchant, $IDService, $IDTransaction) !== false) {
    print_r($cancelpayment->getResult());
} else {
    print_r($cancelpayment->getLastError());
}
/**
 * Samples for Checktransactionstatus ServiceType
 */
$checktransactionstatus = new \ServiceType\Checktransactionstatus($options);
/**
 * Sample call for check_transaction_status operation/method
 */
if ($checktransactionstatus->check_transaction_status($amount, $currency, $hash, $IDMerchant, $IDService, $IDTransaction, $Neosurf_payment_ID, $serial_nb, $transaction_type) !== false) {
    print_r($checktransactionstatus->getResult());
} else {
    print_r($checktransactionstatus->getLastError());
}
/**
 * Samples for Creditcard ServiceType
 */
$creditcard = new \ServiceType\Creditcard($options);
/**
 * Sample call for credit_card operation/method
 */
if ($creditcard->credit_card($amount, $currency, $hash, $IDReseller, $IDTransaction, $IDUser, $serial_nb) !== false) {
    print_r($creditcard->getResult());
} else {
    print_r($creditcard->getLastError());
}
/**
 * Samples for Creditsim ServiceType
 */
$creditsim = new \ServiceType\Creditsim($options);
/**
 * Sample call for credit_sim operation/method
 */
if ($creditsim->credit_sim($amount, $currency, $hash, $IDReseller, $IDTransaction, $IDUser, $operator, $tel_nb) !== false) {
    print_r($creditsim->getResult());
} else {
    print_r($creditsim->getLastError());
}
/**
 * Samples for Getdtickets ServiceType
 */
$getdtickets = new \ServiceType\Getdtickets($options);
/**
 * Sample call for get_dtickets operation/method
 */
if ($getdtickets->get_dtickets($currency, $hash, $IDProduct, $IDReseller, $IDTransaction, $IDUser, $quantity) !== false) {
    print_r($getdtickets->getResult());
} else {
    print_r($getdtickets->getLastError());
}
/**
 * Samples for Getdticketsvoid ServiceType
 */
$getdticketsvoid = new \ServiceType\Getdticketsvoid($options);
/**
 * Sample call for get_dtickets_void operation/method
 */
if ($getdticketsvoid->get_dtickets_void($auth_nb, $hash, $reason_comment, $reason_label) !== false) {
    print_r($getdticketsvoid->getResult());
} else {
    print_r($getdticketsvoid->getLastError());
}
/**
 * Sample call for get_dtickets_void2 operation/method
 */
if ($getdticketsvoid->get_dtickets_void2($IDReseller, $IDTransaction, $IDUser, $hash, $reason_comment, $reason_label) !== false) {
    print_r($getdticketsvoid->getResult());
} else {
    print_r($getdticketsvoid->getLastError());
}
/**
 * Samples for Getrcatalog ServiceType
 */
$getrcatalog = new \ServiceType\Getrcatalog($options);
/**
 * Sample call for get_rcatalog operation/method
 */
if ($getrcatalog->get_rcatalog($hash, $IDReseller, $IDUser) !== false) {
    print_r($getrcatalog->getResult());
} else {
    print_r($getrcatalog->getLastError());
}
/**
 * Samples for Getrtemplatefields ServiceType
 */
$getrtemplatefields = new \ServiceType\Getrtemplatefields($options);
/**
 * Sample call for get_rtemplate_fields operation/method
 */
if ($getrtemplatefields->get_rtemplate_fields($hash, $IDUser, $dt_version) !== false) {
    print_r($getrtemplatefields->getResult());
} else {
    print_r($getrtemplatefields->getLastError());
}
/**
 * Samples for Getecheck ServiceType
 */
$getecheck = new \ServiceType\Getecheck($options);
/**
 * Sample call for get_echeck operation/method
 */
if ($getecheck->get_echeck($amount, $currency, $hash, $IDProduct, $IDReseller, $IDTransaction, $IDUser) !== false) {
    print_r($getecheck->getResult());
} else {
    print_r($getecheck->getLastError());
}
/**
 * Samples for Neocashcheck ServiceType
 */
$neocashcheck = new \ServiceType\Neocashcheck($options);
/**
 * Sample call for neocash_check operation/method
 */
if ($neocashcheck->neocash_check($amount, $currency, $hash, $IDReseller, $IDTransaction, $IDUser, $serial_nb) !== false) {
    print_r($neocashcheck->getResult());
} else {
    print_r($neocashcheck->getLastError());
}
/**
 * Samples for Neocashcredit ServiceType
 */
$neocashcredit = new \ServiceType\Neocashcredit($options);
/**
 * Sample call for neocash_credit operation/method
 */
if ($neocashcredit->neocash_credit($amount, $currency, $hash, $IDReseller, $IDTransaction, $IDUser, $serial_nb) !== false) {
    print_r($neocashcredit->getResult());
} else {
    print_r($neocashcredit->getLastError());
}
/**
 * Samples for Makepayment ServiceType
 */
$makepayment = new \ServiceType\Makepayment($options);
/**
 * Sample call for make_payment operation/method
 */
if ($makepayment->make_payment($amount, $currency, $hash, $IDMerchant, $IDService, $IDTicket, $IDTransaction) !== false) {
    print_r($makepayment->getResult());
} else {
    print_r($makepayment->getLastError());
}
/**
 * Samples for Makepaymentcustinfo ServiceType
 */
$makepaymentcustinfo = new \ServiceType\Makepaymentcustinfo($options);
/**
 * Sample call for make_payment_custinfo operation/method
 */
if ($makepaymentcustinfo->make_payment_custinfo($amount, $currency, $hash, $IDMerchant, $IDService, $IDTicket, $IDTransaction) !== false) {
    print_r($makepaymentcustinfo->getResult());
} else {
    print_r($makepaymentcustinfo->getLastError());
}
/**
 * Samples for Moneytransfer ServiceType
 */
$moneytransfer = new \ServiceType\Moneytransfer($options);
/**
 * Sample call for money_transfer operation/method
 */
if ($moneytransfer->money_transfer($amount, $currency, $giver_country, $giver_email, $giver_first_name, $giver_last_name, $giver_tel, $hash, $IDReseller, $IDTransaction, $IDUser, $pincode, $receiver_country, $receiver_email, $receiver_first_name, $receiver_last_name, $receiver_tel) !== false) {
    print_r($moneytransfer->getResult());
} else {
    print_r($moneytransfer->getLastError());
}
/**
 * Samples for Neopayburncode ServiceType
 */
$neopayburncode = new \ServiceType\Neopayburncode($options);
/**
 * Sample call for neopay_burn_code operation/method
 */
if ($neopayburncode->neopay_burn_code($hash, $IDReseller, $IDTransaction, $IDUser, $pincode) !== false) {
    print_r($neopayburncode->getResult());
} else {
    print_r($neopayburncode->getLastError());
}
/**
 * Samples for Neopaycheckcode ServiceType
 */
$neopaycheckcode = new \ServiceType\Neopaycheckcode($options);
/**
 * Sample call for neopay_check_code operation/method
 */
if ($neopaycheckcode->neopay_check_code($hash, $IDReseller, $IDUser, $pincode) !== false) {
    print_r($neopaycheckcode->getResult());
} else {
    print_r($neopaycheckcode->getLastError());
}
/**
 * Samples for Ticketcheckcredit ServiceType
 */
$ticketcheckcredit = new \ServiceType\Ticketcheckcredit($options);
/**
 * Sample call for ticket_check_credit operation/method
 */
if ($ticketcheckcredit->ticket_check_credit($amount, $hash, $IDMerchant, $IDTicket) !== false) {
    print_r($ticketcheckcredit->getResult());
} else {
    print_r($ticketcheckcredit->getLastError());
}
/**
 * Samples for Transaction ServiceType
 */
$transaction = new \ServiceType\Transaction($options);
/**
 * Sample call for transactionFinalAmount operation/method
 */
if ($transaction->transactionFinalAmount($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionCreditCardWithout3D operation/method
 */
if ($transaction->transactionCreditCardWithout3D($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionGateway operation/method
 */
if ($transaction->transactionGateway($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionGatewayCallback operation/method
 */
if ($transaction->transactionGatewayCallback($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionGatewayCheckCallback operation/method
 */
if ($transaction->transactionGatewayCheckCallback($creditCardBin, $creditCardCountry, $creditCardExpiryDate, $creditCardLast4, $creditCardScheme, $hash, $informations, $transactionId) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionNeosurfCreditEmail operation/method
 */
if ($transaction->transactionNeosurfCreditEmail($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionNeosurfCreditPay operation/method
 */
if ($transaction->transactionNeosurfCreditPay($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionNeosurfPin operation/method
 */
if ($transaction->transactionNeosurfPin($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionNeosurfLogin operation/method
 */
if ($transaction->transactionNeosurfLogin($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionNeosurfReverse operation/method
 */
if ($transaction->transactionNeosurfReverse($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionQrcode operation/method
 */
if ($transaction->transactionQrcode($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionCheckSignature operation/method
 */
if ($transaction->transactionCheckSignature($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionInit operation/method
 */
if ($transaction->transactionInit($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionInit2 operation/method
 */
if ($transaction->transactionInit2($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionKycCheck operation/method
 */
if ($transaction->transactionKycCheck($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionIpAndCountry operation/method
 */
if ($transaction->transactionIpAndCountry($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionClose operation/method
 */
if ($transaction->transactionClose($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionCreditCardWith3D operation/method
 */
if ($transaction->transactionCreditCardWith3D($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionGetDetails operation/method
 */
if ($transaction->transactionGetDetails($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Sample call for transactionNeosurfPinDeposit operation/method
 */
if ($transaction->transactionNeosurfPinDeposit($struct) !== false) {
    print_r($transaction->getResult());
} else {
    print_r($transaction->getLastError());
}
/**
 * Samples for Transactionfa ServiceType
 */
$transactionfa = new \ServiceType\Transactionfa($options);
/**
 * Sample call for transaction2fa operation/method
 */
if ($transactionfa->transaction2fa($struct) !== false) {
    print_r($transactionfa->getResult());
} else {
    print_r($transactionfa->getLastError());
}
/**
 * Samples for Verify ServiceType
 */
$verify = new \ServiceType\Verify($options);
/**
 * Sample call for verifyUserDuplicatesPersonalData operation/method
 */
if ($verify->verifyUserDuplicatesPersonalData($struct) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Samples for User ServiceType
 */
$user = new \ServiceType\User($options);
/**
 * Sample call for userCreateLight operation/method
 */
if ($user->userCreateLight($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userUpdateKycLevel operation/method
 */
if ($user->userUpdateKycLevel($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userUpdatePassword operation/method
 */
if ($user->userUpdatePassword($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userUpdateStatus operation/method
 */
if ($user->userUpdateStatus($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userVerifyLoginExists operation/method
 */
if ($user->userVerifyLoginExists($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userUpdateClientPersonalDetails operation/method
 */
if ($user->userUpdateClientPersonalDetails($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userUpdateConfirmation operation/method
 */
if ($user->userUpdateConfirmation($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userResendConfirmationEmail operation/method
 */
if ($user->userResendConfirmationEmail($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userCreate operation/method
 */
if ($user->userCreate($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userVerifyEmailInit operation/method
 */
if ($user->userVerifyEmailInit($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userVerifyEmailVerifyCode operation/method
 */
if ($user->userVerifyEmailVerifyCode($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userForgotPasswordInit operation/method
 */
if ($user->userForgotPasswordInit($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userForgotPasswordVerifyCode operation/method
 */
if ($user->userForgotPasswordVerifyCode($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userForgotPasswordReset operation/method
 */
if ($user->userForgotPasswordReset($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userGetBalance operation/method
 */
if ($user->userGetBalance($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userTransferInitialize operation/method
 */
if ($user->userTransferInitialize($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userTransferFinalize operation/method
 */
if ($user->userTransferFinalize($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userGetDetails operation/method
 */
if ($user->userGetDetails($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userGetDetailsByEmail operation/method
 */
if ($user->userGetDetailsByEmail($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userUpdatePersonalInfo operation/method
 */
if ($user->userUpdatePersonalInfo($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userLogin operation/method
 */
if ($user->userLogin($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userLogout operation/method
 */
if ($user->userLogout($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userUploadDocument operation/method
 */
if ($user->userUploadDocument($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userHistory operation/method
 */
if ($user->userHistory($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userGetDepositMethods operation/method
 */
if ($user->userGetDepositMethods($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Sample call for userGetLimits operation/method
 */
if ($user->userGetLimits($struct) !== false) {
    print_r($user->getResult());
} else {
    print_r($user->getLastError());
}
/**
 * Samples for Users ServiceType
 */
$users = new \ServiceType\Users($options);
/**
 * Sample call for usersGetLimits operation/method
 */
if ($users->usersGetLimits($struct) !== false) {
    print_r($users->getResult());
} else {
    print_r($users->getLastError());
}
/**
 * Samples for Voucher ServiceType
 */
$voucher = new \ServiceType\Voucher($options);
/**
 * Sample call for VoucherRefreshLogs operation/method
 */
if ($voucher->VoucherRefreshLogs($struct) !== false) {
    print_r($voucher->getResult());
} else {
    print_r($voucher->getLastError());
}
/**
 * Sample call for voucherLogin operation/method
 */
if ($voucher->voucherLogin($struct) !== false) {
    print_r($voucher->getResult());
} else {
    print_r($voucher->getLastError());
}
/**
 * Sample call for voucherLogout operation/method
 */
if ($voucher->voucherLogout($struct) !== false) {
    print_r($voucher->getResult());
} else {
    print_r($voucher->getLastError());
}
/**
 * Sample call for voucherGetBalance operation/method
 */
if ($voucher->voucherGetBalance($struct) !== false) {
    print_r($voucher->getResult());
} else {
    print_r($voucher->getLastError());
}
/**
 * Sample call for voucherGetHistory operation/method
 */
if ($voucher->voucherGetHistory($struct) !== false) {
    print_r($voucher->getResult());
} else {
    print_r($voucher->getLastError());
}
/**
 * Sample call for voucherHistorySerialNb operation/method
 */
if ($voucher->voucherHistorySerialNb($struct) !== false) {
    print_r($voucher->getResult());
} else {
    print_r($voucher->getLastError());
}
/**
 * Sample call for voucherGetDetails operation/method
 */
if ($voucher->voucherGetDetails($struct) !== false) {
    print_r($voucher->getResult());
} else {
    print_r($voucher->getLastError());
}
/**
 * Samples for Pincode ServiceType
 */
$pincode = new \ServiceType\Pincode($options);
/**
 * Sample call for pincodeLogin operation/method
 */
if ($pincode->pincodeLogin($struct) !== false) {
    print_r($pincode->getResult());
} else {
    print_r($pincode->getLastError());
}
/**
 * Samples for Store ServiceType
 */
$store = new \ServiceType\Store($options);
/**
 * Sample call for storeLocator operation/method
 */
if ($store->storeLocator($struct) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Samples for App ServiceType
 */
$app = new \ServiceType\App($options);
/**
 * Sample call for appGetAd operation/method
 */
if ($app->appGetAd($struct) !== false) {
    print_r($app->getResult());
} else {
    print_r($app->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for sendDetailsToMerchant operation/method
 */
if ($send->sendDetailsToMerchant($struct) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for checkSessionId operation/method
 */
if ($check->checkSessionId($struct) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
