<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestrictedTime StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RestrictedTime
 * @subpackage Structs
 */
class RestrictedTime extends AbstractStructBase
{
    /**
     * The FromTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromTime;
    /**
     * The ToTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToTime;
    /**
     * Constructor method for RestrictedTime
     * @uses RestrictedTime::setFromTime()
     * @uses RestrictedTime::setToTime()
     * @param string $fromTime
     * @param string $toTime
     */
    public function __construct($fromTime = null, $toTime = null)
    {
        $this
            ->setFromTime($fromTime)
            ->setToTime($toTime);
    }
    /**
     * Get FromTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromTime()
    {
        return isset($this->FromTime) ? $this->FromTime : null;
    }
    /**
     * Set FromTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromTime
     * @return \StructType\RestrictedTime
     */
    public function setFromTime($fromTime = null)
    {
        // validation for constraint: string
        if (!is_null($fromTime) && !is_string($fromTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromTime, true), gettype($fromTime)), __LINE__);
        }
        if (is_null($fromTime) || (is_array($fromTime) && empty($fromTime))) {
            unset($this->FromTime);
        } else {
            $this->FromTime = $fromTime;
        }
        return $this;
    }
    /**
     * Get ToTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToTime()
    {
        return isset($this->ToTime) ? $this->ToTime : null;
    }
    /**
     * Set ToTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toTime
     * @return \StructType\RestrictedTime
     */
    public function setToTime($toTime = null)
    {
        // validation for constraint: string
        if (!is_null($toTime) && !is_string($toTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toTime, true), gettype($toTime)), __LINE__);
        }
        if (is_null($toTime) || (is_array($toTime) && empty($toTime))) {
            unset($this->ToTime);
        } else {
            $this->ToTime = $toTime;
        }
        return $this;
    }
}
