<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for History StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:History
 * @subpackage Structs
 */
class History extends AbstractStructBase
{
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The HistoryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HistoryDate;
    /**
     * The HistoryId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HistoryId;
    /**
     * The ReservationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationChannel;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserId;
    /**
     * The VoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VoucherNumber;
    /**
     * The VoucherNumberFull
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VoucherNumberFull;
    /**
     * Constructor method for History
     * @uses History::setDetails()
     * @uses History::setHistoryDate()
     * @uses History::setHistoryId()
     * @uses History::setReservationChannel()
     * @uses History::setUserId()
     * @uses History::setVoucherNumber()
     * @uses History::setVoucherNumberFull()
     * @param string $details
     * @param string $historyDate
     * @param int $historyId
     * @param string $reservationChannel
     * @param string $userId
     * @param int $voucherNumber
     * @param string $voucherNumberFull
     */
    public function __construct($details = null, $historyDate = null, $historyId = null, $reservationChannel = null, $userId = null, $voucherNumber = null, $voucherNumberFull = null)
    {
        $this
            ->setDetails($details)
            ->setHistoryDate($historyDate)
            ->setHistoryId($historyId)
            ->setReservationChannel($reservationChannel)
            ->setUserId($userId)
            ->setVoucherNumber($voucherNumber)
            ->setVoucherNumberFull($voucherNumberFull);
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $details
     * @return \StructType\History
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get HistoryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHistoryDate()
    {
        return isset($this->HistoryDate) ? $this->HistoryDate : null;
    }
    /**
     * Set HistoryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $historyDate
     * @return \StructType\History
     */
    public function setHistoryDate($historyDate = null)
    {
        // validation for constraint: string
        if (!is_null($historyDate) && !is_string($historyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($historyDate, true), gettype($historyDate)), __LINE__);
        }
        if (is_null($historyDate) || (is_array($historyDate) && empty($historyDate))) {
            unset($this->HistoryDate);
        } else {
            $this->HistoryDate = $historyDate;
        }
        return $this;
    }
    /**
     * Get HistoryId value
     * @return int|null
     */
    public function getHistoryId()
    {
        return $this->HistoryId;
    }
    /**
     * Set HistoryId value
     * @param int $historyId
     * @return \StructType\History
     */
    public function setHistoryId($historyId = null)
    {
        // validation for constraint: int
        if (!is_null($historyId) && !(is_int($historyId) || ctype_digit($historyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($historyId, true), gettype($historyId)), __LINE__);
        }
        $this->HistoryId = $historyId;
        return $this;
    }
    /**
     * Get ReservationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationChannel()
    {
        return isset($this->ReservationChannel) ? $this->ReservationChannel : null;
    }
    /**
     * Set ReservationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationChannel
     * @return \StructType\History
     */
    public function setReservationChannel($reservationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($reservationChannel) && !is_string($reservationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationChannel, true), gettype($reservationChannel)), __LINE__);
        }
        if (is_null($reservationChannel) || (is_array($reservationChannel) && empty($reservationChannel))) {
            unset($this->ReservationChannel);
        } else {
            $this->ReservationChannel = $reservationChannel;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \StructType\History
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get VoucherNumber value
     * @return int|null
     */
    public function getVoucherNumber()
    {
        return $this->VoucherNumber;
    }
    /**
     * Set VoucherNumber value
     * @param int $voucherNumber
     * @return \StructType\History
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: int
        if (!is_null($voucherNumber) && !(is_int($voucherNumber) || ctype_digit($voucherNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        $this->VoucherNumber = $voucherNumber;
        return $this;
    }
    /**
     * Get VoucherNumberFull value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucherNumberFull()
    {
        return isset($this->VoucherNumberFull) ? $this->VoucherNumberFull : null;
    }
    /**
     * Set VoucherNumberFull value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucherNumberFull
     * @return \StructType\History
     */
    public function setVoucherNumberFull($voucherNumberFull = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNumberFull) && !is_string($voucherNumberFull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNumberFull, true), gettype($voucherNumberFull)), __LINE__);
        }
        if (is_null($voucherNumberFull) || (is_array($voucherNumberFull) && empty($voucherNumberFull))) {
            unset($this->VoucherNumberFull);
        } else {
            $this->VoucherNumberFull = $voucherNumberFull;
        }
        return $this;
    }
}
