<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveAdvancedVoucherDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveAdvancedVoucherDetails
 * @subpackage Structs
 */
class RetrieveAdvancedVoucherDetails extends TransactionInfo
{
    /**
     * The RetrieveVoucherDetailsRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveAdvancedVoucherDetails
     */
    public $RetrieveVoucherDetailsRequest;
    /**
     * The LoadOptions
     * @var string
     */
    public $LoadOptions;
    /**
     * The Vouchers
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfVoucher
     */
    public $Vouchers;
    /**
     * Constructor method for RetrieveAdvancedVoucherDetails
     * @uses RetrieveAdvancedVoucherDetails::setRetrieveVoucherDetailsRequest()
     * @uses RetrieveAdvancedVoucherDetails::setLoadOptions()
     * @uses RetrieveAdvancedVoucherDetails::setVouchers()
     * @param \StructType\RetrieveAdvancedVoucherDetails $retrieveVoucherDetailsRequest
     * @param string $loadOptions
     * @param \ArrayType\ArrayOfVoucher $vouchers
     */
    public function __construct(\StructType\RetrieveAdvancedVoucherDetails $retrieveVoucherDetailsRequest = null, $loadOptions = null, \ArrayType\ArrayOfVoucher $vouchers = null)
    {
        $this
            ->setRetrieveVoucherDetailsRequest($retrieveVoucherDetailsRequest)
            ->setLoadOptions($loadOptions)
            ->setVouchers($vouchers);
    }
    /**
     * Get RetrieveVoucherDetailsRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveAdvancedVoucherDetails|null
     */
    public function getRetrieveVoucherDetailsRequest()
    {
        return isset($this->RetrieveVoucherDetailsRequest) ? $this->RetrieveVoucherDetailsRequest : null;
    }
    /**
     * Set RetrieveVoucherDetailsRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveAdvancedVoucherDetails $retrieveVoucherDetailsRequest
     * @return \StructType\RetrieveAdvancedVoucherDetails
     */
    public function setRetrieveVoucherDetailsRequest(\StructType\RetrieveAdvancedVoucherDetails $retrieveVoucherDetailsRequest = null)
    {
        if (is_null($retrieveVoucherDetailsRequest) || (is_array($retrieveVoucherDetailsRequest) && empty($retrieveVoucherDetailsRequest))) {
            unset($this->RetrieveVoucherDetailsRequest);
        } else {
            $this->RetrieveVoucherDetailsRequest = $retrieveVoucherDetailsRequest;
        }
        return $this;
    }
    /**
     * Get LoadOptions value
     * @return string|null
     */
    public function getLoadOptions()
    {
        return $this->LoadOptions;
    }
    /**
     * Set LoadOptions value
     * @uses \EnumType\RetrieveAdvancedVoucherDetails_VoucherLoadOptions::valueIsValid()
     * @uses \EnumType\RetrieveAdvancedVoucherDetails_VoucherLoadOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loadOptions
     * @return \StructType\RetrieveAdvancedVoucherDetails
     */
    public function setLoadOptions($loadOptions = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetrieveAdvancedVoucherDetails_VoucherLoadOptions::valueIsValid($loadOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RetrieveAdvancedVoucherDetails_VoucherLoadOptions', is_array($loadOptions) ? implode(', ', $loadOptions) : var_export($loadOptions, true), implode(', ', \EnumType\RetrieveAdvancedVoucherDetails_VoucherLoadOptions::getValidValues())), __LINE__);
        }
        $this->LoadOptions = $loadOptions;
        return $this;
    }
    /**
     * Get Vouchers value
     * @return \ArrayType\ArrayOfVoucher|null
     */
    public function getVouchers()
    {
        return $this->Vouchers;
    }
    /**
     * Set Vouchers value
     * @param \ArrayType\ArrayOfVoucher $vouchers
     * @return \StructType\RetrieveAdvancedVoucherDetails
     */
    public function setVouchers(\ArrayType\ArrayOfVoucher $vouchers = null)
    {
        $this->Vouchers = $vouchers;
        return $this;
    }
}
