<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetrieveVoucher
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveVoucher $parameters
     * @return \StructType\RetrieveVoucherResponse|bool
     */
    public function RetrieveVoucher(\StructType\RetrieveVoucher $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveVoucher($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAdvancedVoucherDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAdvancedVoucherDetails $parameters
     * @return \StructType\RetrieveAdvancedVoucherDetailsResponse|bool
     */
    public function RetrieveAdvancedVoucherDetails(\StructType\RetrieveAdvancedVoucherDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAdvancedVoucherDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetrieveAdvancedVoucherDetailsResponse|\StructType\RetrieveVoucherResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
