<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPersonContactInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPersonContactInfo
 * @subpackage Arrays
 */
class ArrayOfPersonContactInfo extends AbstractStructArrayBase
{
    /**
     * The PersonContactInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersonContactInfo[]
     */
    public $PersonContactInfo;
    /**
     * Constructor method for ArrayOfPersonContactInfo
     * @uses ArrayOfPersonContactInfo::setPersonContactInfo()
     * @param \StructType\PersonContactInfo[] $personContactInfo
     */
    public function __construct(array $personContactInfo = array())
    {
        $this
            ->setPersonContactInfo($personContactInfo);
    }
    /**
     * Get PersonContactInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersonContactInfo[]|null
     */
    public function getPersonContactInfo()
    {
        return isset($this->PersonContactInfo) ? $this->PersonContactInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonContactInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonContactInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonContactInfoForArrayConstraintsFromSetPersonContactInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPersonContactInfoPersonContactInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfPersonContactInfoPersonContactInfoItem instanceof \StructType\PersonContactInfo) {
                $invalidValues[] = is_object($arrayOfPersonContactInfoPersonContactInfoItem) ? get_class($arrayOfPersonContactInfoPersonContactInfoItem) : sprintf('%s(%s)', gettype($arrayOfPersonContactInfoPersonContactInfoItem), var_export($arrayOfPersonContactInfoPersonContactInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PersonContactInfo property can only contain items of type \StructType\PersonContactInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PersonContactInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonContactInfo[] $personContactInfo
     * @return \ArrayType\ArrayOfPersonContactInfo
     */
    public function setPersonContactInfo(array $personContactInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($personContactInfoArrayErrorMessage = self::validatePersonContactInfoForArrayConstraintsFromSetPersonContactInfo($personContactInfo))) {
            throw new \InvalidArgumentException($personContactInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($personContactInfo) || (is_array($personContactInfo) && empty($personContactInfo))) {
            unset($this->PersonContactInfo);
        } else {
            $this->PersonContactInfo = $personContactInfo;
        }
        return $this;
    }
    /**
     * Add item to PersonContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonContactInfo $item
     * @return \ArrayType\ArrayOfPersonContactInfo
     */
    public function addToPersonContactInfo(\StructType\PersonContactInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonContactInfo) {
            throw new \InvalidArgumentException(sprintf('The PersonContactInfo property can only contain items of type \StructType\PersonContactInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PersonContactInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PersonContactInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PersonContactInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PersonContactInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PersonContactInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PersonContactInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PersonContactInfo
     */
    public function getAttributeName()
    {
        return 'PersonContactInfo';
    }
}
