<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Payment
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The AmountPaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AmountPaid;
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $BaseAmount;
    /**
     * The BaseCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaseCurrency;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The CurrencyPaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyPaid;
    /**
     * The DatePaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatePaid;
    /**
     * The PaymentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PaymentId;
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The VoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VoucherNumber;
    /**
     * The VoucherNumberFull
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VoucherNumberFull;
    /**
     * Constructor method for Payment
     * @uses Payment::setAmountPaid()
     * @uses Payment::setBaseAmount()
     * @uses Payment::setBaseCurrency()
     * @uses Payment::setConfirmationNumber()
     * @uses Payment::setCurrencyPaid()
     * @uses Payment::setDatePaid()
     * @uses Payment::setPaymentId()
     * @uses Payment::setSeriesNumber()
     * @uses Payment::setVoucherNumber()
     * @uses Payment::setVoucherNumberFull()
     * @param float $amountPaid
     * @param float $baseAmount
     * @param string $baseCurrency
     * @param string $confirmationNumber
     * @param string $currencyPaid
     * @param string $datePaid
     * @param int $paymentId
     * @param string $seriesNumber
     * @param int $voucherNumber
     * @param string $voucherNumberFull
     */
    public function __construct($amountPaid = null, $baseAmount = null, $baseCurrency = null, $confirmationNumber = null, $currencyPaid = null, $datePaid = null, $paymentId = null, $seriesNumber = null, $voucherNumber = null, $voucherNumberFull = null)
    {
        $this
            ->setAmountPaid($amountPaid)
            ->setBaseAmount($baseAmount)
            ->setBaseCurrency($baseCurrency)
            ->setConfirmationNumber($confirmationNumber)
            ->setCurrencyPaid($currencyPaid)
            ->setDatePaid($datePaid)
            ->setPaymentId($paymentId)
            ->setSeriesNumber($seriesNumber)
            ->setVoucherNumber($voucherNumber)
            ->setVoucherNumberFull($voucherNumberFull);
    }
    /**
     * Get AmountPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmountPaid()
    {
        return isset($this->AmountPaid) ? $this->AmountPaid : null;
    }
    /**
     * Set AmountPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amountPaid
     * @return \StructType\Payment
     */
    public function setAmountPaid($amountPaid = null)
    {
        // validation for constraint: float
        if (!is_null($amountPaid) && !(is_float($amountPaid) || is_numeric($amountPaid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountPaid, true), gettype($amountPaid)), __LINE__);
        }
        if (is_null($amountPaid) || (is_array($amountPaid) && empty($amountPaid))) {
            unset($this->AmountPaid);
        } else {
            $this->AmountPaid = $amountPaid;
        }
        return $this;
    }
    /**
     * Get BaseAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBaseAmount()
    {
        return isset($this->BaseAmount) ? $this->BaseAmount : null;
    }
    /**
     * Set BaseAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $baseAmount
     * @return \StructType\Payment
     */
    public function setBaseAmount($baseAmount = null)
    {
        // validation for constraint: float
        if (!is_null($baseAmount) && !(is_float($baseAmount) || is_numeric($baseAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseAmount, true), gettype($baseAmount)), __LINE__);
        }
        if (is_null($baseAmount) || (is_array($baseAmount) && empty($baseAmount))) {
            unset($this->BaseAmount);
        } else {
            $this->BaseAmount = $baseAmount;
        }
        return $this;
    }
    /**
     * Get BaseCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaseCurrency()
    {
        return isset($this->BaseCurrency) ? $this->BaseCurrency : null;
    }
    /**
     * Set BaseCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baseCurrency
     * @return \StructType\Payment
     */
    public function setBaseCurrency($baseCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($baseCurrency) && !is_string($baseCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseCurrency, true), gettype($baseCurrency)), __LINE__);
        }
        if (is_null($baseCurrency) || (is_array($baseCurrency) && empty($baseCurrency))) {
            unset($this->BaseCurrency);
        } else {
            $this->BaseCurrency = $baseCurrency;
        }
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return isset($this->ConfirmationNumber) ? $this->ConfirmationNumber : null;
    }
    /**
     * Set ConfirmationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationNumber
     * @return \StructType\Payment
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        if (is_null($confirmationNumber) || (is_array($confirmationNumber) && empty($confirmationNumber))) {
            unset($this->ConfirmationNumber);
        } else {
            $this->ConfirmationNumber = $confirmationNumber;
        }
        return $this;
    }
    /**
     * Get CurrencyPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyPaid()
    {
        return isset($this->CurrencyPaid) ? $this->CurrencyPaid : null;
    }
    /**
     * Set CurrencyPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyPaid
     * @return \StructType\Payment
     */
    public function setCurrencyPaid($currencyPaid = null)
    {
        // validation for constraint: string
        if (!is_null($currencyPaid) && !is_string($currencyPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyPaid, true), gettype($currencyPaid)), __LINE__);
        }
        if (is_null($currencyPaid) || (is_array($currencyPaid) && empty($currencyPaid))) {
            unset($this->CurrencyPaid);
        } else {
            $this->CurrencyPaid = $currencyPaid;
        }
        return $this;
    }
    /**
     * Get DatePaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatePaid()
    {
        return isset($this->DatePaid) ? $this->DatePaid : null;
    }
    /**
     * Set DatePaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datePaid
     * @return \StructType\Payment
     */
    public function setDatePaid($datePaid = null)
    {
        // validation for constraint: string
        if (!is_null($datePaid) && !is_string($datePaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datePaid, true), gettype($datePaid)), __LINE__);
        }
        if (is_null($datePaid) || (is_array($datePaid) && empty($datePaid))) {
            unset($this->DatePaid);
        } else {
            $this->DatePaid = $datePaid;
        }
        return $this;
    }
    /**
     * Get PaymentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPaymentId()
    {
        return isset($this->PaymentId) ? $this->PaymentId : null;
    }
    /**
     * Set PaymentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $paymentId
     * @return \StructType\Payment
     */
    public function setPaymentId($paymentId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentId) && !(is_int($paymentId) || ctype_digit($paymentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentId, true), gettype($paymentId)), __LINE__);
        }
        if (is_null($paymentId) || (is_array($paymentId) && empty($paymentId))) {
            unset($this->PaymentId);
        } else {
            $this->PaymentId = $paymentId;
        }
        return $this;
    }
    /**
     * Get SeriesNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return isset($this->SeriesNumber) ? $this->SeriesNumber : null;
    }
    /**
     * Set SeriesNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesNumber
     * @return \StructType\Payment
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        if (is_null($seriesNumber) || (is_array($seriesNumber) && empty($seriesNumber))) {
            unset($this->SeriesNumber);
        } else {
            $this->SeriesNumber = $seriesNumber;
        }
        return $this;
    }
    /**
     * Get VoucherNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVoucherNumber()
    {
        return isset($this->VoucherNumber) ? $this->VoucherNumber : null;
    }
    /**
     * Set VoucherNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $voucherNumber
     * @return \StructType\Payment
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: int
        if (!is_null($voucherNumber) && !(is_int($voucherNumber) || ctype_digit($voucherNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        if (is_null($voucherNumber) || (is_array($voucherNumber) && empty($voucherNumber))) {
            unset($this->VoucherNumber);
        } else {
            $this->VoucherNumber = $voucherNumber;
        }
        return $this;
    }
    /**
     * Get VoucherNumberFull value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucherNumberFull()
    {
        return isset($this->VoucherNumberFull) ? $this->VoucherNumberFull : null;
    }
    /**
     * Set VoucherNumberFull value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucherNumberFull
     * @return \StructType\Payment
     */
    public function setVoucherNumberFull($voucherNumberFull = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNumberFull) && !is_string($voucherNumberFull)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNumberFull, true), gettype($voucherNumberFull)), __LINE__);
        }
        if (is_null($voucherNumberFull) || (is_array($voucherNumberFull) && empty($voucherNumberFull))) {
            unset($this->VoucherNumberFull);
        } else {
            $this->VoucherNumberFull = $voucherNumberFull;
        }
        return $this;
    }
}
