<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketOriginDestination StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MarketOriginDestination
 * @subpackage Structs
 */
class MarketOriginDestination extends AbstractStructBase
{
    /**
     * The FromAirport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromAirport;
    /**
     * The MarketCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarketCode;
    /**
     * The ToAirport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToAirport;
    /**
     * Constructor method for MarketOriginDestination
     * @uses MarketOriginDestination::setFromAirport()
     * @uses MarketOriginDestination::setMarketCode()
     * @uses MarketOriginDestination::setToAirport()
     * @param string $fromAirport
     * @param string $marketCode
     * @param string $toAirport
     */
    public function __construct($fromAirport = null, $marketCode = null, $toAirport = null)
    {
        $this
            ->setFromAirport($fromAirport)
            ->setMarketCode($marketCode)
            ->setToAirport($toAirport);
    }
    /**
     * Get FromAirport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromAirport()
    {
        return isset($this->FromAirport) ? $this->FromAirport : null;
    }
    /**
     * Set FromAirport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromAirport
     * @return \StructType\MarketOriginDestination
     */
    public function setFromAirport($fromAirport = null)
    {
        // validation for constraint: string
        if (!is_null($fromAirport) && !is_string($fromAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromAirport, true), gettype($fromAirport)), __LINE__);
        }
        if (is_null($fromAirport) || (is_array($fromAirport) && empty($fromAirport))) {
            unset($this->FromAirport);
        } else {
            $this->FromAirport = $fromAirport;
        }
        return $this;
    }
    /**
     * Get MarketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarketCode()
    {
        return isset($this->MarketCode) ? $this->MarketCode : null;
    }
    /**
     * Set MarketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marketCode
     * @return \StructType\MarketOriginDestination
     */
    public function setMarketCode($marketCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketCode) && !is_string($marketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketCode, true), gettype($marketCode)), __LINE__);
        }
        if (is_null($marketCode) || (is_array($marketCode) && empty($marketCode))) {
            unset($this->MarketCode);
        } else {
            $this->MarketCode = $marketCode;
        }
        return $this;
    }
    /**
     * Get ToAirport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToAirport()
    {
        return isset($this->ToAirport) ? $this->ToAirport : null;
    }
    /**
     * Set ToAirport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toAirport
     * @return \StructType\MarketOriginDestination
     */
    public function setToAirport($toAirport = null)
    {
        // validation for constraint: string
        if (!is_null($toAirport) && !is_string($toAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toAirport, true), gettype($toAirport)), __LINE__);
        }
        if (is_null($toAirport) || (is_array($toAirport) && empty($toAirport))) {
            unset($this->ToAirport);
        } else {
            $this->ToAirport = $toAirport;
        }
        return $this;
    }
}
