<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rdxappint.radixxuat.com/RDX/Radixx.ConnectPoint/ConnectPoint.utilities.svc?singleWSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rdxappint.radixxuat.com/RDX/Radixx.ConnectPoint/ConnectPoint.utilities.svc?singleWSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \ServiceType\Retrieve($options);
/**
 * Sample call for RetrievePNRBookingAgent operation/method
 */
if ($retrieve->RetrievePNRBookingAgent(new \StructType\RetrievePNRBookingAgent()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveSystemOptionValue operation/method
 */
if ($retrieve->RetrieveSystemOptionValue(new \StructType\RetrieveSystemOptionValue()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveHtmlReciept operation/method
 */
if ($retrieve->RetrieveHtmlReciept(new \StructType\RetrieveHtmlReciept()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveServiceInformation operation/method
 */
if ($retrieve->RetrieveServiceInformation(new \StructType\RetrieveServiceInformation()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveBuddyListTypes operation/method
 */
if ($retrieve->RetrieveBuddyListTypes(new \StructType\RetrieveBuddyListTypes()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateExternalBookingReference operation/method
 */
if ($update->UpdateExternalBookingReference(new \StructType\UpdateExternalBookingReference()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Clear ServiceType
 */
$clear = new \ServiceType\Clear($options);
/**
 * Sample call for ClearServiceCache operation/method
 */
if ($clear->ClearServiceCache(new \StructType\ClearServiceCache()) !== false) {
    print_r($clear->getResult());
} else {
    print_r($clear->getLastError());
}
