<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViewSystemOptionValue StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViewSystemOptionValue
 * @subpackage Structs
 */
class ViewSystemOptionValue extends AbstractStructBase
{
    /**
     * The SystemOptionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemOptionValue;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ViewSystemOptionValue
     * @uses ViewSystemOptionValue::setSystemOptionValue()
     * @uses ViewSystemOptionValue::setExceptions()
     * @param string $systemOptionValue
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct($systemOptionValue = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setSystemOptionValue($systemOptionValue)
            ->setExceptions($exceptions);
    }
    /**
     * Get SystemOptionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemOptionValue()
    {
        return isset($this->SystemOptionValue) ? $this->SystemOptionValue : null;
    }
    /**
     * Set SystemOptionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemOptionValue
     * @return \StructType\ViewSystemOptionValue
     */
    public function setSystemOptionValue($systemOptionValue = null)
    {
        // validation for constraint: string
        if (!is_null($systemOptionValue) && !is_string($systemOptionValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemOptionValue, true), gettype($systemOptionValue)), __LINE__);
        }
        if (is_null($systemOptionValue) || (is_array($systemOptionValue) && empty($systemOptionValue))) {
            unset($this->SystemOptionValue);
        } else {
            $this->SystemOptionValue = $systemOptionValue;
        }
        return $this;
    }
    /**
     * Get Exceptions value
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return $this->Exceptions;
    }
    /**
     * Set Exceptions value
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ViewSystemOptionValue
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this->Exceptions = $exceptions;
        return $this;
    }
}
