<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveSystemOptionValue StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveSystemOptionValue
 * @subpackage Structs
 */
class RetrieveSystemOptionValue extends TransactionInfo
{
    /**
     * The RetrieveSystemOptionValueRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveSystemOptionValue
     */
    public $RetrieveSystemOptionValueRequest;
    /**
     * The SystemOptionKeyword
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SystemOptionKeyword;
    /**
     * Constructor method for RetrieveSystemOptionValue
     * @uses RetrieveSystemOptionValue::setRetrieveSystemOptionValueRequest()
     * @uses RetrieveSystemOptionValue::setSystemOptionKeyword()
     * @param \StructType\RetrieveSystemOptionValue $retrieveSystemOptionValueRequest
     * @param string $systemOptionKeyword
     */
    public function __construct(\StructType\RetrieveSystemOptionValue $retrieveSystemOptionValueRequest = null, $systemOptionKeyword = null)
    {
        $this
            ->setRetrieveSystemOptionValueRequest($retrieveSystemOptionValueRequest)
            ->setSystemOptionKeyword($systemOptionKeyword);
    }
    /**
     * Get RetrieveSystemOptionValueRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveSystemOptionValue|null
     */
    public function getRetrieveSystemOptionValueRequest()
    {
        return isset($this->RetrieveSystemOptionValueRequest) ? $this->RetrieveSystemOptionValueRequest : null;
    }
    /**
     * Set RetrieveSystemOptionValueRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveSystemOptionValue $retrieveSystemOptionValueRequest
     * @return \StructType\RetrieveSystemOptionValue
     */
    public function setRetrieveSystemOptionValueRequest(\StructType\RetrieveSystemOptionValue $retrieveSystemOptionValueRequest = null)
    {
        if (is_null($retrieveSystemOptionValueRequest) || (is_array($retrieveSystemOptionValueRequest) && empty($retrieveSystemOptionValueRequest))) {
            unset($this->RetrieveSystemOptionValueRequest);
        } else {
            $this->RetrieveSystemOptionValueRequest = $retrieveSystemOptionValueRequest;
        }
        return $this;
    }
    /**
     * Get SystemOptionKeyword value
     * @return string|null
     */
    public function getSystemOptionKeyword()
    {
        return $this->SystemOptionKeyword;
    }
    /**
     * Set SystemOptionKeyword value
     * @param string $systemOptionKeyword
     * @return \StructType\RetrieveSystemOptionValue
     */
    public function setSystemOptionKeyword($systemOptionKeyword = null)
    {
        // validation for constraint: string
        if (!is_null($systemOptionKeyword) && !is_string($systemOptionKeyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemOptionKeyword, true), gettype($systemOptionKeyword)), __LINE__);
        }
        $this->SystemOptionKeyword = $systemOptionKeyword;
        return $this;
    }
}
