<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveHtmlReceipt StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveHtmlReceipt
 * @subpackage Structs
 */
class RetrieveHtmlReceipt extends TransactionInfo
{
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The CustomerType
     * @var string
     */
    public $CustomerType;
    /**
     * The LanguageCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LanguageCode;
    /**
     * Constructor method for RetrieveHtmlReceipt
     * @uses RetrieveHtmlReceipt::setReservationInfo()
     * @uses RetrieveHtmlReceipt::setCustomerType()
     * @uses RetrieveHtmlReceipt::setLanguageCode()
     * @param \StructType\ReservationInfo $reservationInfo
     * @param string $customerType
     * @param string $languageCode
     */
    public function __construct(\StructType\ReservationInfo $reservationInfo = null, $customerType = null, $languageCode = null)
    {
        $this
            ->setReservationInfo($reservationInfo)
            ->setCustomerType($customerType)
            ->setLanguageCode($languageCode);
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\RetrieveHtmlReceipt
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get CustomerType value
     * @return string|null
     */
    public function getCustomerType()
    {
        return $this->CustomerType;
    }
    /**
     * Set CustomerType value
     * @uses \EnumType\Enumerations_CustomerTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CustomerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customerType
     * @return \StructType\RetrieveHtmlReceipt
     */
    public function setCustomerType($customerType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CustomerTypes::valueIsValid($customerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CustomerTypes', is_array($customerType) ? implode(', ', $customerType) : var_export($customerType, true), implode(', ', \EnumType\Enumerations_CustomerTypes::getValidValues())), __LINE__);
        }
        $this->CustomerType = $customerType;
        return $this;
    }
    /**
     * Get LanguageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param string $languageCode
     * @return \StructType\RetrieveHtmlReceipt
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->LanguageCode = $languageCode;
        return $this;
    }
}
