<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OAFlightPerson StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OAFlightPerson
 * @subpackage Structs
 */
class OAFlightPerson extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The RecordNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RecordNumber;
    /**
     * The PersonOrgID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PersonOrgID;
    /**
     * The ResSegStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ResSegStatus;
    /**
     * Constructor method for OAFlightPerson
     * @uses OAFlightPerson::setKey()
     * @uses OAFlightPerson::setRecordNumber()
     * @uses OAFlightPerson::setPersonOrgID()
     * @uses OAFlightPerson::setResSegStatus()
     * @param string $key
     * @param int $recordNumber
     * @param int $personOrgID
     * @param int $resSegStatus
     */
    public function __construct($key = null, $recordNumber = null, $personOrgID = null, $resSegStatus = null)
    {
        $this
            ->setKey($key)
            ->setRecordNumber($recordNumber)
            ->setPersonOrgID($personOrgID)
            ->setResSegStatus($resSegStatus);
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\OAFlightPerson
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get RecordNumber value
     * @return int|null
     */
    public function getRecordNumber()
    {
        return $this->RecordNumber;
    }
    /**
     * Set RecordNumber value
     * @param int $recordNumber
     * @return \StructType\OAFlightPerson
     */
    public function setRecordNumber($recordNumber = null)
    {
        // validation for constraint: int
        if (!is_null($recordNumber) && !(is_int($recordNumber) || ctype_digit($recordNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordNumber, true), gettype($recordNumber)), __LINE__);
        }
        $this->RecordNumber = $recordNumber;
        return $this;
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\OAFlightPerson
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get ResSegStatus value
     * @return int|null
     */
    public function getResSegStatus()
    {
        return $this->ResSegStatus;
    }
    /**
     * Set ResSegStatus value
     * @param int $resSegStatus
     * @return \StructType\OAFlightPerson
     */
    public function setResSegStatus($resSegStatus = null)
    {
        // validation for constraint: int
        if (!is_null($resSegStatus) && !(is_int($resSegStatus) || ctype_digit($resSegStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resSegStatus, true), gettype($resSegStatus)), __LINE__);
        }
        $this->ResSegStatus = $resSegStatus;
        return $this;
    }
}
