<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingReference StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BookingReference
 * @subpackage Structs
 */
class BookingReference extends AbstractStructBase
{
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The ExternalBookingID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ExternalBookingID;
    /**
     * The ExternalBookingCRSCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ExternalBookingCRSCode;
    /**
     * Constructor method for BookingReference
     * @uses BookingReference::setLogicalFlightID()
     * @uses BookingReference::setDepartureDate()
     * @uses BookingReference::setExternalBookingID()
     * @uses BookingReference::setExternalBookingCRSCode()
     * @param int $logicalFlightID
     * @param string $departureDate
     * @param string $externalBookingID
     * @param string $externalBookingCRSCode
     */
    public function __construct($logicalFlightID = null, $departureDate = null, $externalBookingID = null, $externalBookingCRSCode = null)
    {
        $this
            ->setLogicalFlightID($logicalFlightID)
            ->setDepartureDate($departureDate)
            ->setExternalBookingID($externalBookingID)
            ->setExternalBookingCRSCode($externalBookingCRSCode);
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\BookingReference
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\BookingReference
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ExternalBookingID value
     * @return string|null
     */
    public function getExternalBookingID()
    {
        return $this->ExternalBookingID;
    }
    /**
     * Set ExternalBookingID value
     * @param string $externalBookingID
     * @return \StructType\BookingReference
     */
    public function setExternalBookingID($externalBookingID = null)
    {
        // validation for constraint: string
        if (!is_null($externalBookingID) && !is_string($externalBookingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalBookingID, true), gettype($externalBookingID)), __LINE__);
        }
        $this->ExternalBookingID = $externalBookingID;
        return $this;
    }
    /**
     * Get ExternalBookingCRSCode value
     * @return string|null
     */
    public function getExternalBookingCRSCode()
    {
        return $this->ExternalBookingCRSCode;
    }
    /**
     * Set ExternalBookingCRSCode value
     * @param string $externalBookingCRSCode
     * @return \StructType\BookingReference
     */
    public function setExternalBookingCRSCode($externalBookingCRSCode = null)
    {
        // validation for constraint: string
        if (!is_null($externalBookingCRSCode) && !is_string($externalBookingCRSCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalBookingCRSCode, true), gettype($externalBookingCRSCode)), __LINE__);
        }
        $this->ExternalBookingCRSCode = $externalBookingCRSCode;
        return $this;
    }
}
